#!/bin/sh

# SDK=~/Android/Sdk
# BUILDTOOLS=$(ls $ANDROID_SDK/build-tools | grep "[2-3]." | sort | tail -n 1)
BUILDTOOLS=$BUILD_TOOLS
PLATFORM=$(ls $ANDROID_SDK/platforms | grep "[2-3]." | sort | tail -n 1 | sed "s/android-//g")
NDKPREFIX=$(cd $ANDROID_NDK && find . | grep "aarch64-linux-android$PLATFORM-clang" | sort | tail -n 1 | sed "s:/aarch64-linux-android$PLATFORM-clang.*$::g;s:^\./::g")

cat << EOF | tee Make.android.config
SDKPREFIX=$ANDROID_SDK
JAVA_HOME=/usr
BUILDTOOLS=$BUILDTOOLS
PLATFORM=$PLATFORM
NDKPREFIX=$ANDROID_NDK/$NDKPREFIX
EOF

sleep 1
make -f Make.android drawterm-unsigned.apk

