package org.eagsoftware.laundrynotes.data;

import android.content.Context;

import androidx.room.Database;
import androidx.room.Room;
import androidx.room.RoomDatabase;

import org.eagsoftware.laundrynotes.Utilities;

/** Pattern Singleton*/
@Database(entities = {ArticoloEntity.class}, version = 1)
public abstract class LavanderiaDB extends RoomDatabase {
    private static LavanderiaDB db = null;
    public abstract ArticoloDAO getArticoloDAO();

    public static LavanderiaDB getInstance(Context appContext){
        if(db == null) db = Room.databaseBuilder(appContext, LavanderiaDB.class, Utilities.DB_NAME).build();
        return db;
    }

    public static synchronized void closeInstance() {
        if(db != null) {
            db.close();
            db = null;
        }
    }
}
