package org.eagsoftware.laundrynotes.data;

import android.os.Parcel;
import android.os.Parcelable;

import androidx.annotation.Nullable;
import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.PrimaryKey;

@Entity(tableName = "lavanderia")
public class ArticoloEntity implements Parcelable {
    @PrimaryKey(autoGenerate = true)
    @ColumnInfo(name="id_articolo")
    private long idArticolo;
    private String nome = "";
    private int tipologia = 0;
    @ColumnInfo(name="lavaggio_acqua")
    private int lavaggioAcqua = 0;
    @ColumnInfo(name="lavaggio_secco")
    private int lavaggioSecco = 0;
    private int temperatura = 0;
    private int candeggio = 0;
    private int avvertenze = 0;
    private int asciugatura = 0;
    @ColumnInfo(name="all_ombra")
    private boolean allOmbra = false;
    private int asciugatrice = 0;
    private int stiratura = 0;
    private String note = "";

    private String immURI;

    /* COSTRUTTORI */
    public ArticoloEntity() {
    }

    public ArticoloEntity(long idArticolo){
        this.idArticolo = idArticolo;
    }

    // Implementazione di Parcelable
    protected ArticoloEntity(Parcel in) {
        idArticolo = in.readLong();
        nome = in.readString();
        tipologia = in.readInt();
        lavaggioAcqua = in.readInt();
        lavaggioSecco = in.readInt();
        temperatura = in.readInt();
        candeggio = in.readInt();
        avvertenze = in.readInt();
        asciugatura = in.readInt();
        allOmbra = in.readByte() != 0;
        asciugatrice = in.readInt();
        stiratura = in.readInt();
        note = in.readString();
        immURI = in.readString();
    }

    /** Getter & setters */
    public long getIdArticolo() {
        return idArticolo;
    }
    public void setIdArticolo(long idArticolo) {
        this.idArticolo = idArticolo;
    }
    public String getNome() {
        return nome;
    }
    public void setNome(String nome) {
        this.nome = nome;
    }
    public int getTipologia() {
        return tipologia;
    }
    public void setTipologia(int tipologia) {
        this.tipologia = tipologia;
    }
    public int getLavaggioAcqua() {
        return lavaggioAcqua;
    }
    public void setLavaggioAcqua(int lavaggioAcqua) {
        this.lavaggioAcqua = lavaggioAcqua;
    }
    public int getLavaggioSecco() {
        return lavaggioSecco;
    }
    public void setLavaggioSecco(int lavaggioSecco) {
        this.lavaggioSecco = lavaggioSecco;
    }
    public int getTemperatura() {
        return temperatura;
    }
    public void setTemperatura(int temperatura) {
        this.temperatura = temperatura;
    }
    public int getCandeggio() {
        return candeggio;
    }
    public void setCandeggio(int candeggio) {
        this.candeggio = candeggio;
    }
    public int getAvvertenze() {
        return avvertenze;
    }
    public void setAvvertenze(int avvertenze) {
        this.avvertenze = avvertenze;
    }
    public int getAsciugatura() {
        return asciugatura;
    }
    public void setAsciugatura(int asciugatura) {
        this.asciugatura = asciugatura;
    }
    public boolean isAllOmbra() {
        return allOmbra;
    }
    public void setAllOmbra(boolean allOmbra) {
        this.allOmbra = allOmbra;
    }
    public int getAsciugatrice() {
        return asciugatrice;
    }
    public void setAsciugatrice(int asciugatrice) {
        this.asciugatrice = asciugatrice;
    }
    public int getStiratura() {
        return stiratura;
    }
    public void setStiratura(int stiratura) {
        this.stiratura = stiratura;
    }
    public String getNote() {
        return note;
    }
    public void setNote(String note) {
        this.note = note;
    }
    public String getImmURI() {
        return immURI;
    }
    public void setImmURI(String immURI) {
        this.immURI = immURI;
    }

    /* METODI NECESSARI PER Parcelable */

    public static final Creator<ArticoloEntity> CREATOR = new Creator<ArticoloEntity>() {
        @Override
        public ArticoloEntity createFromParcel(Parcel in) {
            return new ArticoloEntity(in);
        }

        @Override
        public ArticoloEntity[] newArray(int size) {
            return new ArticoloEntity[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(idArticolo);
        dest.writeString(nome);
        dest.writeInt(tipologia);
        dest.writeInt(lavaggioAcqua);
        dest.writeInt(lavaggioSecco);
        dest.writeInt(temperatura);
        dest.writeInt(candeggio);
        dest.writeInt(avvertenze);
        dest.writeInt(asciugatura);
        dest.writeByte((byte) (allOmbra ? 1 : 0));
        dest.writeInt(asciugatrice);
        dest.writeInt(stiratura);
        dest.writeString(note);
        dest.writeString(immURI);
    }

    /* METODI PERSONALIZZATI */

    @Override
    public boolean equals(@Nullable Object obj) {
        // Riferimento identico
        if (this == obj) return true;

        //Controllo null e tipo
        if (obj == null || getClass() != obj.getClass()) return false;

        ArticoloEntity art = (ArticoloEntity) obj;

        boolean equalUri = (immURI == null || art.immURI == null) ? immURI == null && art.immURI == null :
                immURI.equals(art.immURI);

        return  idArticolo == art.idArticolo &&
                nome.equals(art.nome) &&
                tipologia == art.tipologia &&
                lavaggioAcqua == art.lavaggioAcqua &&
                lavaggioSecco == art.lavaggioSecco &&
                temperatura == art.temperatura &&
                candeggio == art.candeggio &&
                avvertenze == art.avvertenze &&
                asciugatura == art.asciugatura &&
                allOmbra == art.allOmbra &&
                asciugatrice == art.asciugatrice &&
                stiratura == art.stiratura &&
                note.equals(art.note) &&
                equalUri;
    }
}
