package org.eagsoftware.laundrynotes.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import org.eagsoftware.laundrynotes.R;

import java.util.List;

public class DetailSpinnerAdapter extends ArrayAdapter<String> {
    protected final Context context;
    protected final int layoutItemID;
    protected final int layoutSelItemID;
    protected final String[] descriptions;
    protected final List<Integer> iconIDs;  //Array di risorse delle immagini

    public DetailSpinnerAdapter(Context context, String[] descriptions, List<Integer> iconIDs,
                                int layoutItemID){
        super(context, R.layout.spinner_item, descriptions);
        this.context = context;
        this.layoutItemID = layoutItemID;
        this.layoutSelItemID = layoutItemID;
        this.descriptions = descriptions;
        this.iconIDs = iconIDs;
    }

    public DetailSpinnerAdapter(Context context, String[] descriptions, List<Integer> iconIDs,
                                int layoutItemID, int layoutSelItemID){
        super(context, R.layout.spinner_item, descriptions);
        this.context = context;
        this.layoutItemID = layoutItemID;
        this.layoutSelItemID = layoutSelItemID;
        this.descriptions = descriptions;
        this.iconIDs = iconIDs;
    }

    @Override
    public View getDropDownView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
        return createView(position, parent, layoutItemID);
    }

    @NonNull
    @Override
    public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
        return createView(position, parent, layoutSelItemID);
    }

    protected View createView(int position, ViewGroup parent, int lytItemID){
        LayoutInflater ifrSpinner = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);

        View rowView = ifrSpinner.inflate(lytItemID, parent, false);
        TextView txwDesc = rowView.findViewById(R.id.txw_spi_desc);
        ImageView imwIco = rowView.findViewById(R.id.imw_spi_ico);

        // Imposta il testo e l'immagine (se esistente)
        // Se è il primo elemento dello spinner, imposta il testo sull'hint e non sul testo
        if (position==0) {
            txwDesc.setText("");
            txwDesc.setHint(descriptions[position]);
        } else txwDesc.setText(descriptions[position]);
        if(iconIDs.get(position) != -1) imwIco.setImageResource(iconIDs.get(position));

        return rowView;
    }
}
