package org.eagsoftware.laundrynotes.activities;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.view.animation.AnimationUtils;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.Spinner;

import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.google.android.material.snackbar.Snackbar;

import org.eagsoftware.laundrynotes.GestoreFileImm;
import org.eagsoftware.laundrynotes.R;
import org.eagsoftware.laundrynotes.Utilities;
import org.eagsoftware.laundrynotes.adapters.DetailSpinnerAdapter;
import org.eagsoftware.laundrynotes.adapters.MainRecyclerAdapter;
import org.eagsoftware.laundrynotes.data.ArticoloEntity;
import org.eagsoftware.laundrynotes.data.LavanderiaDB;

import java.io.File;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;


public class MainActivity extends AppCompatActivity implements GestoreFileImm.OnErrorListener{
    View mainView;
    ExecutorService executorService;
    MainRecyclerAdapter adpRecycler;
    GestoreFileImm mGestFileImm;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        mainView = findViewById(android.R.id.content);

        int colID = Utilities.getIntColorFromAttr(this, android.R.attr.statusBarColor);
        Utilities.setSystemBarsAppearance(getWindow(), colID);

        mGestFileImm = new GestoreFileImm(this);
        mGestFileImm.svuotaCartella(new File(getFilesDir() + "/images/temp"));

        setLista();
        leggiExtraDaActivity();
        setFABaggiungi();
        setFABsettings();

    }

    /** Gestione degli errori per la classe GestoreFileImm (usata in MainRecyclerAdapter) */
    @Override
    public void onError(Exception exc) {
        Utilities.getCopyErrSnb(mainView, getString(R.string.errore_generico),
                exc.getMessage() + Utilities.extractStackTrace(exc.getStackTrace())).show();
    }


    /*-----------------------------------------------------------------------------------------------------*/
    /* METODI PERSONALIZZATI */

    /** Imposta lista (recyclerView) */
    private void setLista(){
        RecyclerView rcwLista = findViewById(R.id.rcw_main_lista);
        //rcwLista.setLayoutManager(new LinearLayoutManager(this));    // Impostato nel layout.xml

        Context activityContext = this;
        executorService = Executors.newSingleThreadExecutor();
        executorService.execute(new Runnable() {
            @Override
            public void run() {
                List<ArticoloEntity> listaArticoli =
                        LavanderiaDB.getInstance(getApplicationContext()).getArticoloDAO().listaCompleta();

                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        adpRecycler = new MainRecyclerAdapter(activityContext, listaArticoli);
                        rcwLista.setAdapter(adpRecycler);

                        setToolbar();
                    }
                });
            }
        });
    }

    /** Gestione toolbar */
    private void setToolbar(){
        ImageButton imbCerca = findViewById(R.id.imb_main_cerca);
        EditText edtCerca = findViewById(R.id.edt_main_cerca);
        Spinner spnTipo = findViewById(R.id.spn_main_tipo);
        imbCerca.setOnClickListener(new View.OnClickListener() {
            // Gestione visibilità elementi toolbar al click del pulsante cerca
            @Override
            public void onClick(View view) {
                if(edtCerca.getVisibility() == View.GONE) {
                    imbCerca.setImageDrawable(Utilities.getDrawableFromID(getApplicationContext(),
                            android.R.attr.actionModeCloseDrawable));
                    spnTipo.setVisibility(View.GONE);
                    spnTipo.startAnimation(AnimationUtils.loadAnimation(getApplicationContext(),
                            R.anim.slide_out_down));
                    edtCerca.setVisibility(View.VISIBLE);
                    edtCerca.startAnimation(AnimationUtils.loadAnimation(getApplicationContext(),
                            R.anim.slide_in_right));
                } else {
                    edtCerca.setText("");
                    imbCerca.setImageDrawable(Utilities.getDrawableFromID(getApplicationContext(),
                            android.R.attr.actionModeWebSearchDrawable));
                    edtCerca.setVisibility(View.GONE);
                    edtCerca.startAnimation(AnimationUtils.loadAnimation(getApplicationContext(),
                            R.anim.slide_out_right));
                    spnTipo.setSelection(0);
                    spnTipo.setVisibility(View.VISIBLE);
                    spnTipo.startAnimation(AnimationUtils.loadAnimation(getApplicationContext(),
                            R.anim.slide_in_down));
                }
            }
        });
        // Gestione editText
        edtCerca.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                if(adpRecycler != null) adpRecycler.filtraByNome(charSequence.toString());
                else Utilities.getCopyErrSnb(mainView, getString(R.string.errore_generico),
                                "L'adapter della spinner non è ancora stato caricato - adpRecycler is null").show();
            }

            @Override
            public void afterTextChanged(Editable editable) {
            }
        });

        // Gestione spinner
        setSpinner(R.id.spn_main_tipo, R.array.tipologia_testo, R.array.tipologia_icone);
    }

    /** Imposta spinner */
    public void setSpinner(int spinnerID, int descArrayID, int iconArrayID){
        Spinner spn = findViewById(spinnerID);
        String[] descriptions = getResources().getStringArray(descArrayID);
        List<Integer> icons = Utilities.getArrayListID(getApplicationContext(), iconArrayID);

        if (descriptions.length != icons.size()) throw new IllegalArgumentException(
                "Il numero di voci non corrisponde al numero di icone.");

        // Imposta manualmente il primo elemento della lista
        descriptions[0] = getString(R.string.tutte_le_categorie);

        DetailSpinnerAdapter adpSpinner = new DetailSpinnerAdapter(this, descriptions, icons,
                R.layout.spinner_item, R.layout.spinner_item_light_text);
        spn.setAdapter(adpSpinner);

        spn.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> adapterView, View view, int position, long id) {
                if (adpRecycler != null) adpRecycler.filtraByTipo(position);
                else Utilities.getCopyErrSnb(mainView, getString(R.string.errore_generico),
                        "L'adapter della spinner non è ancora stato caricato - adpRecycler is null").show();
            }

            @Override
            public void onNothingSelected(AdapterView<?> adapterView) {
            }
        });
    }

    /** Imposta il click sul floating action button */
    private void setFABaggiungi(){
        FloatingActionButton btnMain = findViewById(R.id.fab_main_add);
        btnMain.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Intent itnShowAct = new Intent(getApplicationContext(), DetailActivity.class);
                startActivity(itnShowAct);
                overridePendingTransition(R.anim.slide_in_right, R.anim.fade_out);
            }
        });
    }


    /** Imposta il click sul floating action button */
    private void setFABsettings(){
        FloatingActionButton btnMain = findViewById(R.id.fab_main_set);
        btnMain.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Intent itnShowAct = new Intent(getApplicationContext(), SettingsActivity.class);
                startActivity(itnShowAct);
                overridePendingTransition(R.anim.slide_in_left, R.anim.fade_out);
            }
        });
    }


    /** Legge gli extra che arrivano dalla detail activity o dalla settings activity*/
    private void leggiExtraDaActivity(){
        Intent intAvvio = getIntent();
        short nuovoArt = intAvvio.getShortExtra("NUOVO", (short) 0);
        short aggiornaArt = intAvvio.getShortExtra("AGGIORNA", (short) 0);
        short fallito = intAvvio.getShortExtra("FALLITO", (short) 0);
        boolean dbAggiornato = intAvvio.getBooleanExtra("DB_AGGIORNATO", false);
        String snbMsg = null;
        if (nuovoArt != 0 ) if (nuovoArt == 1) snbMsg = getString(R.string.nuovo_articolo);
                            else snbMsg = getString(R.string.nuovo_articolo_annullato);
        if (aggiornaArt != 0) if (aggiornaArt == 1) snbMsg = getString(R.string.articolo_aggiornato);
                            else snbMsg = getString(R.string.aggiornamento_articolo_annullato);
        if (fallito != 0) snbMsg = getString(R.string.errore_generico);
        if (dbAggiornato) {
            setLista();
            snbMsg = getString(R.string.database_importato);
        }

        // Pulisce l'intent per evitare riletture in caso di ricaricamento da backStack
        setIntent(new Intent());

        if (snbMsg != null) Snackbar.make(mainView, snbMsg, Snackbar.LENGTH_SHORT).show();
    }
}