package org.eagsoftware.laundrynotes.activities;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ArgbEvaluator;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.util.Log;
import android.view.ContextMenu;
import android.view.MenuItem;
import android.view.View;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.Spinner;
import android.widget.TextView;

import androidx.activity.OnBackPressedCallback;
import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;

import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.google.android.material.snackbar.Snackbar;

import org.eagsoftware.laundrynotes.GestoreFileImm;
import org.eagsoftware.laundrynotes.R;
import org.eagsoftware.laundrynotes.UIFormController;
import org.eagsoftware.laundrynotes.Utilities;
import org.eagsoftware.laundrynotes.adapters.DetailSpinner2IconsAdapter;
import org.eagsoftware.laundrynotes.adapters.DetailSpinnerAdapter;
import org.eagsoftware.laundrynotes.data.ArticoloEntity;
import org.eagsoftware.laundrynotes.data.LavanderiaDB;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class DetailActivity extends AppCompatActivity implements GestoreFileImm.OnErrorListener {
    ExecutorService mExecutorService;            // Per la chiamata asincrona
    ArticoloEntity mArticolo = null;             // Per definire l'elemento della lista
    Uri mFotoUri = null;                         // Per la posizione dell'immagine
    View mDetailActivity = null;
    ImageView mImwImg = null;
    FloatingActionButton mFabSalva;
    ConstraintLayout mCnl1 = null;
    GestoreFileImm mGestoreFileImm = null;
    Boolean flagImmSchermoIntero = false;
    Boolean flagDeleteFoto = false;
    UIFormController mFormCtr;
    final MutableLiveData<Boolean> mFlagEdit = new MutableLiveData<>(false);
    ActivityResultLauncher<Intent> launcherScegli;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_detail);

        int colID = Utilities.getIntColorFromAttr(this, android.R.attr.statusBarColor);
        Utilities.setSystemBarsAppearance(getWindow(), colID);

        mDetailActivity = findViewById(android.R.id.content);
        mImwImg = findViewById(R.id.imw_det_image);
        mFabSalva = findViewById(R.id.fab_det_salva);
        mCnl1 = findViewById(R.id.cnl_det_1);

        mGestoreFileImm = new GestoreFileImm(
                getApplicationContext(),
                getApplicationContext().getPackageName() + ".fileprovider",
                getFilesDir(),
                this
        );

        mFormCtr= new UIFormController(this, popolaMapCampiForm());
        setObserver();

        setSpinner(R.id.spn_det_tipo, R.array.tipologia_testo, R.array.tipologia_icone);
        setSpinner(R.id.spn_det_lav_acqua, R.array.lavaggio_acqua_testo, R.array.lavaggio_acqua_icone);
        setSpinner(R.id.spn_det_lav_secco, R.array.lavaggio_secco_testo, R.array.lavaggio_secco_icone);
        setSpinner(R.id.spn_det_temp, R.array.temperatura_testo, R.array.temperatura_icone);
        setSpinner(R.id.spn_det_cand, R.array.candeggio_testo, R.array.candeggio_icone,
                R.array.candeggio_icone_2);
        setSpinner(R.id.spn_det_lav_avv, R.array.avvertenze_testo, R.array.avvertenze_icone);
        setSpinner(R.id.spn_det_asciugatura, R.array.asciugatura_testo, R.array.asciugatura_icone,
                R.array.asciugatura_icone_2);
        setCbxAscOmbra();
        setSpinner(R.id.spn_det_asciugatrice, R.array.asciugatrice_testo, R.array.asciugatrice_icone);
        setSpinner(R.id.spn_det_stir, R.array.stiratura_testo, R.array.stiratura_icone);

        mArticolo = getIntent().getParcelableExtra("objArticolo");
        mFotoUri = getFotoUri();
        setCampiForm();
        setFabSalva();
        setImwImgListener();
        inizializzaLauncherActivity();

        setOnBackPressed();
    }


    @Override
    public void onCreateContextMenu(ContextMenu menu, View v, ContextMenu.ContextMenuInfo menuInfo) {
        super.onCreateContextMenu(menu, v, menuInfo);
        getMenuInflater().inflate(R.menu.context_imageview, menu);
    }

    @Override
    public boolean onContextItemSelected(@NonNull MenuItem item) {
        if (item.getItemId() == R.id.cmi_imw_acquisisci) requestFoto();
        else if (item.getItemId() == R.id.cmi_imw_elimina) {
            flagDeleteFoto = true;
            mImwImg.setImageURI(null);
        }
        return true;
    }


    @Override
    public void finish(){
        super.finish();
        overridePendingTransition(R.anim.fade_in, R.anim.slide_out_right);
    }

    /** Gestione errori per la classe GestoreFileImm */
    @Override
    public void onError(Exception exc) {
        Utilities.getCopyErrSnb(mDetailActivity, getString(R.string.errore_generico),
                exc.getMessage() + Utilities.extractStackTrace(exc.getStackTrace())).show();
    }


    /*-----------------------------------------------------------------------------------------------------*/
    /* METODI PERSONALIZZATI */


    private void setObserver() {
        TextView txwAggImm = findViewById(R.id.txw_det_agg_imm);
        mFlagEdit.observe(this, new Observer<Boolean>() {
            @Override
            public void onChanged(Boolean editMode) {
                if (editMode){
                    mFormCtr.setEnable(true);
                    mFormCtr.showAll();
                    txwAggImm.setText(R.string.aggiungi_immagine);
                    // Aggiunge il context menù
                    if (mFotoUri != null) registerForContextMenu(mImwImg);
                    animazioneFab(mFabSalva, R.drawable.ic_ui_save);
                } else {
                    mFormCtr.setEnable(false);
                    mFormCtr.showOnlyUsed();
                    txwAggImm.setText("");
                    // Rimuove il context menù
                    unregisterForContextMenu(mImwImg);
                    animazioneFab(mFabSalva, R.drawable.ic_ui_edit);
                }
            }
        });
    }


    /** Cattura un'immagine con la fotocamera */
    private void requestFoto(){
        Intent itnFoto = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);
        if(itnFoto.resolveActivity(getPackageManager()) != null){
            if(mFotoUri != null) mGestoreFileImm.eliminaFile(mFotoUri);
            mFotoUri = mGestoreFileImm.creaFileTemp("images/temp", "TEMP_IMAGE");
            itnFoto.putExtra(MediaStore.EXTRA_OUTPUT, mFotoUri);
        }

        Intent itnImpImm = new Intent(Intent.ACTION_PICK, MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
        itnImpImm.setType("image/*");

        List<Intent> itnList = new ArrayList<>();
        if (itnFoto.resolveActivity(getPackageManager()) != null) itnList.add(itnFoto);
        if (itnImpImm.resolveActivity(getPackageManager()) != null) itnList.add(itnImpImm);

        Intent itnScegli;
        if (!itnList.isEmpty()){
            Intent itnBase = itnList.remove(itnList.size() - 1);
            itnScegli = Intent.createChooser(itnBase, getString(R.string.come_acquisire));
            itnScegli.putExtra(Intent.EXTRA_INITIAL_INTENTS, itnList.toArray(new Parcelable[0]));
            launcherScegli.launch(itnScegli);
        }
    }


    /** Gestisci la visibilità degli elementi del form */
    private void animateForm(boolean isVisible){
        ScrollView scwScroll = findViewById(R.id.scw_det_scroll);
        LinearLayout lnlNome = findViewById(R.id.lnl_det_nome);
        FloatingActionButton fabSalva = findViewById(R.id.fab_det_salva);
        int visibilita, animazioneId;
        if(isVisible) {
            visibilita = View.VISIBLE;
            animazioneId = R.anim.fade_in;
        } else {
            visibilita = View.GONE;
            animazioneId = R.anim.fade_out;
        }

        scwScroll.setVisibility(visibilita);
        scwScroll.startAnimation(AnimationUtils.loadAnimation(getApplicationContext(), animazioneId));
        lnlNome.setVisibility(visibilita);
        lnlNome.startAnimation(AnimationUtils.loadAnimation(getApplicationContext(), animazioneId));
        fabSalva.setVisibility(visibilita);
        fabSalva.startAnimation(AnimationUtils.loadAnimation(getApplicationContext(), animazioneId));
    }


    /** Allarga l'image view al click */
    private void animateImageView(float startPercent, float endPercent){
        AnimatorSet animatorSet = new AnimatorSet();
        int animDur = getResources().getInteger(R.integer.anim_dur_std);

        // Animazione layout
        ValueAnimator anmLayout = ValueAnimator.ofFloat(startPercent, endPercent);
        anmLayout.setDuration(animDur);
        anmLayout.addUpdateListener(new ValueAnimator.AnimatorUpdateListener() {
            @Override
            public void onAnimationUpdate(@NonNull ValueAnimator valueAnimator) {
                ConstraintSet cns = new ConstraintSet();
                cns.clone(mCnl1);
                float percent = (float) valueAnimator.getAnimatedValue();
                cns.constrainPercentHeight(R.id.imw_det_image, percent);
                cns.applyTo(mCnl1);
            }
        });

        // Animazione imageview
        ValueAnimator anmImageview = ValueAnimator.ofFloat(0, 1);
        anmImageview.setDuration(animDur);
        anmImageview.addUpdateListener(new ValueAnimator.AnimatorUpdateListener() {
            @Override
            public void onAnimationUpdate(@NonNull ValueAnimator valueAnimator) {
                float value = (float) valueAnimator.getAnimatedValue();
                mImwImg.setScaleX(value);
                mImwImg.setScaleY(value);
            }
        });

        animatorSet.playTogether(anmLayout, anmImageview);
        if(mImwImg.getScaleType() == ImageView.ScaleType.FIT_CENTER)
            mImwImg.setScaleType(ImageView.ScaleType.CENTER_CROP);
        else mImwImg.setScaleType(ImageView.ScaleType.FIT_CENTER);
        animatorSet.start();
        // anmLayout.start();
    }


    /** Definisce nuovi limiti per allargare l'imageview e garantire una buona visualizzazione
     * dell'immagine */
    @SuppressWarnings("all")
    private void setImwAllargata(boolean isAllargata){
        ConstraintSet cns = new ConstraintSet();
        cns.clone(mCnl1);
        if(isAllargata) {
            float percent = Utilities.getFloatFromID(getApplicationContext(), R.fraction.det_image_prop);
            cns.constrainHeight(R.id.imw_det_image, 0);
            cns.clear(R.id.lnl_det_nome, ConstraintSet.TOP);
            cns.connect(R.id.lnl_det_nome, ConstraintSet.TOP, R.id.gdl_det_2, ConstraintSet.BOTTOM, 0);
        } else {
            int height = (int) getResources().getDimension(R.dimen.min_touch);
            cns.constrainHeight(R.id.imw_det_image, height);
            cns.clear(R.id.lnl_det_nome, ConstraintSet.TOP);
            cns.connect(R.id.lnl_det_nome, ConstraintSet.TOP, R.id.gdl_det_1, ConstraintSet.BOTTOM, 0);
        }
        cns.applyTo(mCnl1);
    }


    /** Imposta la spinner in base allo spinnerAdapter personalizzato (cfr classe apposita) */
    private void setSpinner(int spinnerID, int descArrayID, int iconArrayID){

        Spinner spn = findViewById(spinnerID);
        String[] descriptions = getResources().getStringArray(descArrayID);
        List<Integer> icons = Utilities.getArrayListID(getApplicationContext(), iconArrayID);

        if (descriptions.length != icons.size()) throw new IllegalArgumentException(
                "Il numero di voci non corrisponde al numero di icone.");

        DetailSpinnerAdapter adpSpinner =
                new DetailSpinnerAdapter(this, descriptions, icons, R.layout.spinner_item);
        spn.setAdapter(adpSpinner);
    }

    /** Imposta la spinner in base allo spinnerAdapter personalizzato (cfr classe apposita) - v. 2icone */
    private void setSpinner(int spinnerID, int descArrayID, int icon1ArrayID, int icon2ArrayID){

        Spinner spn = findViewById(spinnerID);
        String[] descriptions = getResources().getStringArray(descArrayID);
        List<Integer> icons1 = Utilities.getArrayListID(getApplicationContext(), icon1ArrayID);
        List<Integer> icons2 = Utilities.getArrayListID(getApplicationContext(), icon2ArrayID);

        if (descriptions.length != icons1.size() || descriptions.length != icons2.size())
            throw new IllegalArgumentException("Il numero di voci non corrisponde al numero di icone.");

        DetailSpinner2IconsAdapter adpSpinner = new DetailSpinner2IconsAdapter
        (this, descriptions, icons1, icons2, R.layout.spinner_item);
        spn.setAdapter(adpSpinner);
    }

    /** Determina il comportamento dell'imageView associata in base allo stato cheched*/
    private void setCbxAscOmbra(){
        CheckBox cbxAscOmbra = findViewById(R.id.cbx_det_asc_ombra);
        ImageView imwAscOmbra = findViewById(R.id.imw_det_asc_ombra);
        int cIdCbxChecked = ContextCompat.getColor(this, R.color.primary);
        int cIdTextChecked = ContextCompat.getColor(this,
                Utilities.getIntColorFromID(this, android.R.attr.textColorPrimary));
        int cIdUncheked = ContextCompat.getColor(this,
                Utilities.getIntColorFromID(this, android.R.attr.textColorHint));


        int [][] stati = {{android.R.attr.state_checked}, {-android.R.attr.state_checked}};
        int [] colori = {cIdCbxChecked, cIdUncheked};
        cbxAscOmbra.setButtonTintList(new ColorStateList(stati, colori));

        cbxAscOmbra.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(@NonNull CompoundButton compoundButton, boolean b) {
                imwAscOmbra.setVisibility((b) ? View.VISIBLE : View.INVISIBLE);
                cbxAscOmbra.setTextColor((b) ? cIdTextChecked : cIdUncheked);
            }
        });
    }


    private Uri getFotoUri(){
        if(mArticolo != null) {
            String stringUri = mArticolo.getImmURI();
            if (stringUri != null) {
                Uri uri = Uri.parse(stringUri);
                // Verifica se la risorsa associata all'Uri esiste
                if (mGestoreFileImm.esisteFile(uri)) return uri;
                else {
                    Log.e("getFotoUri", "Impossibile trovare il file associato all'Uri");
                    mArticolo.setImmURI(null);
                    new Thread(new Runnable() {
                        @Override
                        public void run() {
                            LavanderiaDB.getInstance(getApplicationContext()).getArticoloDAO().aggiornaArticolo(mArticolo);
                            runOnUiThread(new Runnable() {
                                @Override
                                public void run() {
                                    Snackbar.make(mDetailActivity, R.string.ripeti_foto,
                                            Snackbar.LENGTH_LONG).show();
                                }
                            });
                        }
                    }).start();
                }
            }
        }
        return null;
    }

    private void setCampiForm(){
        // Nuovo articolo
        if (mArticolo == null) {
            mFlagEdit.setValue(true);
            return;
        }

        // Articolo modificato
        mImwImg.setImageURI(mFotoUri);
        if (mFotoUri != null) setImwAllargata(true);

        // Carica i valori nella UI e imposta la corretta visualizzazione.
        mFormCtr.setValues(mArticolo);
        mFormCtr.setEnable(false);
        mFormCtr.showOnlyUsed();
    }


    private Map<String, Object> popolaMapCampiForm(){
        Map<String, Object> campiForm = new HashMap<>();

        campiForm.put("nome", findViewById(R.id.etx_det_nome));
        campiForm.put("tipo", findViewById(R.id.spn_det_tipo));
        campiForm.put("lav_acqua", findViewById(R.id.spn_det_lav_acqua));
        campiForm.put("lav_secco", findViewById(R.id.spn_det_lav_secco));
        campiForm.put("temp", findViewById(R.id.spn_det_temp));
        campiForm.put("cand", findViewById(R.id.spn_det_cand));
        campiForm.put("lav_avv", findViewById(R.id.spn_det_lav_avv));
        campiForm.put("asciugatura", findViewById(R.id.spn_det_asciugatura));
        campiForm.put("asc_ombra", findViewById(R.id.cbx_det_asc_ombra));
        campiForm.put("asciugatrice", findViewById(R.id.spn_det_asciugatrice));
        campiForm.put("stir", findViewById(R.id.spn_det_stir));
        campiForm.put("note", findViewById(R.id.etm_det_note));

        return campiForm;
    }


    /** Salvataggio delle informazioni nel database */
    private void setFabSalva(){
        mFabSalva.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (Boolean.TRUE.equals(mFlagEdit.getValue())){
                    salva();
                } else {
                    mFlagEdit.setValue(true);
                }
            }
        });
    }


    private void salva(){
        if(!validaInput()) {
            Snackbar.make(mDetailActivity, R.string.riempi_campi, Snackbar.LENGTH_LONG)
                    .show();
            return;
        }

        ArticoloEntity art;
        if(mArticolo == null) art = new ArticoloEntity();
        else art = mArticolo;
        setInputInArticleObj(art);

        if (flagDeleteFoto) {
            mGestoreFileImm.eliminaFile(mFotoUri);
            mFotoUri = null;
        }

        if(mFotoUri != null) {
            if(mFotoUri.toString().contains("temp"))
                // Prima di memorizzare l'Uri, l'immagine passa da temporanea a finalizzata.
                mFotoUri = mGestoreFileImm.promuoviImmagine(mFotoUri,
                        "images",
                        UUID.randomUUID().toString());
            art.setImmURI(mFotoUri.toString());
        } else  art.setImmURI(null);

        mExecutorService = Executors.newSingleThreadExecutor();
        mExecutorService.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    long res;
                    if(mArticolo == null)
                        res = LavanderiaDB.getInstance(getApplicationContext()).getArticoloDAO().creaArticolo(art);
                    else {
                        res = LavanderiaDB.getInstance(getApplicationContext()).getArticoloDAO().aggiornaArticolo(art);
                    }
                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            if(res > 0 && mArticolo == null) startMainActivity("NUOVO", (short)1);
                            else if (res > 0) startMainActivity("AGGIORNA", (short)1);
                            else startMainActivity("FALLITO", (short) 1);
                        }
                    });
                } catch (Exception exc) {
                    Log.e("salvataggio dati", "Impossibile aggiornare database; " + exc.getMessage());
                    if(mArticolo == null) startMainActivity("NUOVO", (short)-1);
                    else startMainActivity("AGGIORNA", (short)-1);
                }
            }
        });

        mFlagEdit.setValue(false);
    }


    private void animazioneFab(FloatingActionButton fab, int resID){
        ObjectAnimator animator = ObjectAnimator.ofFloat(fab, "rotation", 0f, 360f);
        animator.setDuration(300);
        animator.setInterpolator(new DecelerateInterpolator());

        animator.addUpdateListener(animation -> {
            float value = (float) animation.getAnimatedValue();
            if (value > 100f && value < 200f) {
                fab.setImageResource(resID);
            }
        });

        animator.addListener(new AnimatorListenerAdapter() {
            @Override
            public void onAnimationEnd(Animator animation) {
                // Per essere sicuri che l'icona sia stata impostata
                fab.setImageResource(resID);
            }
        });

        animator.start();
    }


    /** Validazione input */
    private boolean validaInput(){
        boolean isValid = true;
        EditText etxNome = findViewById(R.id.etx_det_nome);
        Spinner spnTipo = findViewById(R.id.spn_det_tipo);
        LinearLayout lnlNome = findViewById(R.id.lnl_det_nome);
        ScrollView scwScroll = findViewById(R.id.scw_det_scroll);

        String nome = etxNome.getText().toString().trim();
        int tipo = spnTipo.getSelectedItemPosition();
        int errCol = ContextCompat.getColor(getApplicationContext(), R.color.error);
        int errDur = getResources().getInteger(R.integer.anim_dur_err_fade);
        if(nome.isEmpty()) {
            animateBackgroundColor(lnlNome, errCol, errDur);
            isValid = false;
        }
        if (tipo == 0) {
            animateBackgroundColor(spnTipo, errCol, errDur);
            isValid = false;
        }
        if(!isValid) scwScroll.scrollTo(0, 0);
        return isValid;
    }


    private void setImwImgListener(){
        mImwImg.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (mFotoUri == null && Boolean.TRUE.equals(mFlagEdit.getValue())) requestFoto();
                else if (mFotoUri != null && !flagImmSchermoIntero) {
                    flagImmSchermoIntero = true;
                    animateForm(false);
                    animateImageView(Utilities.getFloatFromID(getApplicationContext(),
                            R.fraction.det_image_prop), 1f);
                }
            }
        });
    }



    /** Colora il background (se possibile) della view e lo sfuma al colore iniziale
     * @param view la view a cui applicare l'animazione
     * @param startColor il colore iniziale da cui parte la sfumatura
     * @param millis durata dell'animazione */
    private void animateBackgroundColor(View view, int startColor, int millis){
        // Ottiene il colore di partenza
        int finalColor = (view.getBackground() instanceof ColorDrawable) ?
                ((ColorDrawable) view.getBackground()).getColor() : Color.WHITE;

        ObjectAnimator obaBkg = ObjectAnimator.ofObject(view, "backgroundColor",
                new ArgbEvaluator(), startColor , finalColor);
        obaBkg.setDuration(millis);
        obaBkg.start();
    }


    /** Carica i dati dell'input nell'oggetto ArticoloEntity !TRANNE L'URI!
     * @param art oggetto nel quale viene caricato l'input */
    private void setInputInArticleObj(@NonNull ArticoloEntity art){
        mFormCtr.putValuesInArticleObj(art);
    }


    private void inizializzaLauncherActivity(){
       launcherScegli = registerForActivityResult(new ActivityResultContracts.StartActivityForResult(), new ActivityResultCallback<ActivityResult>() {
           @Override
           public void onActivityResult(ActivityResult actRes) {
               if (actRes.getResultCode() == Activity.RESULT_OK) {
                   Intent data = actRes.getData();
                   // se getData è nullo allora l'utente ha scelto di scattare la foto e mFotoUri è già
                   // impostata.
                   if (data != null && data.getData() != null){
                       Uri impUri = data.getData();
                       mFotoUri = mGestoreFileImm.creaFileTemp("images/temp", "TEMP_IMAGE");
                       mGestoreFileImm.copiaContenutoFileConLimiti(impUri, mFotoUri);
                   }
                   setImwAllargata(true);
                   mImwImg.setImageURI(mFotoUri);
               } else {
                   mFotoUri = null;
                   Snackbar.make(mDetailActivity, R.string.no_cattura_img, Snackbar.LENGTH_SHORT).show();
               }
           }
       });
    }


    /** Copia il contenuto nell'URI di destinazione, applicando la conversione in JPEG e un limite massimo
     * sulla dimensione - necessario per limiti imposti sulla ImageView di Android che potrebbe non
     * riuscire a mostrare le immagini più grandi. */
    private void startMainActivity(String extraName, short extraValue){
        Intent itnShowMainAct = new Intent(getApplicationContext(),
                MainActivity.class);
        itnShowMainAct.putExtra(extraName, extraValue);
        itnShowMainAct.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK);
        startActivity(itnShowMainAct);
    }


    private void setOnBackPressed(){
        OnBackPressedCallback cbkBack = new OnBackPressedCallback(true) {
            @Override
            public void handleOnBackPressed() {
                // Gestione chiusura immagine schermo intero
                if(flagImmSchermoIntero) {
                    animateImageView(1f, Utilities.getFloatFromID(getApplicationContext(),
                            R.fraction.det_image_prop));
                    animateForm(true);
                    flagImmSchermoIntero = false;
                } else {
                    // Gestione chiusura detailActivity: confronta l'articolo originale con un nuovo
                    // oggetto ArticoloEntity riempito con i dati di input: se sono diversi apre il dialog
                    ArticoloEntity vecchioArt = (mArticolo != null) ? mArticolo : new ArticoloEntity(-1);
                    ArticoloEntity nuovoArt = (mArticolo != null) ?
                            new ArticoloEntity(mArticolo.getIdArticolo()) : new ArticoloEntity(-1);
                    setInputInArticleObj(nuovoArt);
                    if (mFotoUri != null) nuovoArt.setImmURI(mFotoUri.toString());
                    if (!nuovoArt.equals(vecchioArt)) confirmExit();
                    else finish();
                }
            }
        };
        getOnBackPressedDispatcher().addCallback(this, cbkBack);
    }

    /** Gestione AlertDialog di chiusura activity */
    private void confirmExit() {
        AlertDialog.Builder adbExit = new AlertDialog.Builder(this);
        adbExit.setTitle(R.string.conferma_chiusura);
        adbExit.setMessage(R.string.conferma_chiusura_text);
        adbExit.setPositiveButton(R.string.si, new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialogInterface, int i) {
                finish();
            }
        });
        adbExit.setNegativeButton(R.string.no, new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialogInterface, int i) {
                dialogInterface.dismiss();
            }
        });
        adbExit.create().show();
    }

}