package org.eagsoftware.laundrynotes;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.Spinner;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;

import org.eagsoftware.laundrynotes.data.ArticoloEntity;

import java.util.Map;
import java.util.Objects;

public class UIFormController {
    final Context context;
    final Map<String, Object> campiForm;
    final Drawable cbxDefaultDrawable;

    public UIFormController(Context context, Map<String, Object> campiForm){
        this.campiForm = campiForm;
        this.context = context;
        // Ottiene il valore di default della checkbox per poterla ripristinare una volta nascosta
        cbxDefaultDrawable = ((CheckBox) Objects.requireNonNull(campiForm.get("asc_ombra"))).getButtonDrawable();
    }


    @SuppressWarnings("DataFlowIssue")
    public void setValues(ArticoloEntity articolo){
        ((EditText)campiForm.get("nome")).setText(articolo.getNome());
        ((Spinner)campiForm.get("tipo")).setSelection(articolo.getTipologia());
        ((Spinner)campiForm.get("lav_acqua")).setSelection(articolo.getLavaggioAcqua());
        ((Spinner)campiForm.get("lav_secco")).setSelection(articolo.getLavaggioSecco());
        ((Spinner)campiForm.get("temp")).setSelection(articolo.getTemperatura());
        ((Spinner)campiForm.get("cand")).setSelection(articolo.getCandeggio());
        ((Spinner)campiForm.get("lav_avv")).setSelection(articolo.getAvvertenze());
        ((Spinner)campiForm.get("asciugatura")).setSelection(articolo.getAsciugatura());
        ((CheckBox)campiForm.get("asc_ombra")).setChecked(articolo.isAllOmbra());
        ((Spinner)campiForm.get("asciugatrice")).setSelection(articolo.getAsciugatrice());
        ((Spinner)campiForm.get("stir")).setSelection(articolo.getStiratura());
        ((EditText)campiForm.get("note")).setText(articolo.getNote());
    }


    /** Carica i dati dell'input nell'oggetto ArticoloEntity !TRANNE L'URI!
     * @param art oggetto nel quale viene caricato l'input */
    @SuppressWarnings("DataFlowIssue")
    public void putValuesInArticleObj(@NonNull ArticoloEntity art){
        art.setNome(((EditText)campiForm.get("nome")).getText().toString());
        art.setTipologia(((Spinner)campiForm.get("tipo")).getSelectedItemPosition());
        art.setLavaggioAcqua(((Spinner)campiForm.get("lav_acqua")).getSelectedItemPosition());
        art.setLavaggioSecco(((Spinner)campiForm.get("lav_secco")).getSelectedItemPosition());
        art.setTemperatura(((Spinner)campiForm.get("temp")).getSelectedItemPosition());
        art.setCandeggio(((Spinner)campiForm.get("cand")).getSelectedItemPosition());
        art.setAvvertenze(((Spinner)campiForm.get("lav_avv")).getSelectedItemPosition());
        art.setAsciugatura(((Spinner)campiForm.get("asciugatura")).getSelectedItemPosition());
        art.setAllOmbra(((CheckBox)campiForm.get("asc_ombra")).isChecked());
        art.setAsciugatrice(((Spinner)campiForm.get("asciugatrice")).getSelectedItemPosition());
        art.setStiratura(((Spinner)campiForm.get("stir")).getSelectedItemPosition());
        art.setNote(((EditText)campiForm.get("note")).getText().toString());
    }


    public void setEnable(Boolean toggle){
        for (Map.Entry<String, Object> entry : campiForm.entrySet()) {
            String chiave = entry.getKey();
            Object campo = entry.getValue();
            if(campo instanceof Spinner) {
                ((Spinner) campo).setEnabled(toggle);
            } else if (campo instanceof CheckBox) {
                CheckBox cbx = ((CheckBox) campo);
                ((CheckBox) campo).setEnabled(toggle);
                if (toggle) ((CheckBox) campo).setButtonDrawable(cbxDefaultDrawable);
                else {
                    ((CheckBox) campo).setButtonDrawable(R.drawable.cbx_empty);
                    ((CheckBox) campo).setPadding(0, cbx.getPaddingTop(), cbx.getPaddingRight(),
                            cbx.getPaddingBottom());
                }
            } else if (campo instanceof EditText){
                if(chiave.equals("nome")) {
                    ColorStateList clrList = (toggle) ?
                            ContextCompat.getColorStateList(context, R.color.white) :
                            ContextCompat.getColorStateList(context, R.color.trasparent);
                    ((EditText) campo).setBackgroundTintList(clrList);
                }
                if(chiave.equals("note")){
                    ColorStateList clrList = (toggle) ?
                            ContextCompat.getColorStateList(context, R.color.edt_bkg_color) :
                            ContextCompat.getColorStateList(context, R.color.trasparent);
                    ((EditText) campo).setBackgroundTintList(clrList);
                }
               ((EditText) campo).setEnabled(toggle);
            }
        }
    }


    public void showAll(){
        setVisibility(true);
    }


    public void showOnlyUsed(){
        setVisibility(false);
    }


    /** Imposta la visibilità dei campi in base al contenuto e alla modalità */
    private void setVisibility(boolean mostraTutto){
        for (Map.Entry<String, Object> entry : campiForm.entrySet()) {
            Object campo = entry.getValue();
            if(campo instanceof Spinner) {
                if (((Spinner)campo).getSelectedItemId() == 0 && !mostraTutto)
                    ((Spinner) campo).setVisibility(View.GONE);
                else ((Spinner) campo).setVisibility(View.VISIBLE);
            } else if (campo instanceof CheckBox) {
                if(!((CheckBox) campo).isChecked() && !mostraTutto)
                    ((LinearLayout)((CheckBox) campo).getParent()).setVisibility(View.GONE);
                else ((LinearLayout)((CheckBox) campo).getParent()).setVisibility(View.VISIBLE);
            } else if (campo instanceof EditText){
                if(((EditText) campo).getText().toString().isEmpty() && !mostraTutto)
                    ((EditText) campo).setVisibility(View.GONE);
                else ((EditText) campo).setVisibility(View.VISIBLE);
            }
        }
    }

}
