package org.codeberg.quecomet.oshi

import org.codeberg.quecomet.oshi.model.api.parseCurlResponse
import org.junit.Assert.assertEquals
import org.junit.Test

const val EXAMPLE_MANAGE_CURL_RESPONSE =
    """Filename: WNxV.txt
Main download: https://oshi.ec/kwkw
Tor download: http://5ety7tpkim5me6eszuwcje7bmy25pbtrjtue7zkqqgziljwqy3rrikqd.onion/kwkw
Size: 0
Type: inode/x-empty
Hashsum: da39a3ee5e6b4b0d3255bfef95601890afd80709 (SHA1)
Created: Sat Dec 16 04:33:45 2023
Expires: Sun Dec 17 04:33:45 2023
Destroy after download: No 
Onion only: No 
Hits: 0/1000
Delete file: https://oshi.ec/a/2303ac72e6987a61ef73c504abb4e8d7f710e269/delete
"""

class GeneralUnitTest {
    @Test
    fun parseCurlResponse_works() {
      val map = parseCurlResponse(EXAMPLE_MANAGE_CURL_RESPONSE)
      assertEquals("https://oshi.ec/kwkw", map["main_download"])
      assertEquals("http://5ety7tpkim5me6eszuwcje7bmy25pbtrjtue7zkqqgziljwqy3rrikqd.onion/kwkw", map["tor_download"])
      assertEquals("0", map["size"])
      assertEquals("da39a3ee5e6b4b0d3255bfef95601890afd80709 (SHA1)", map["hashsum"])
      assertEquals("Sat Dec 16 04:33:45 2023", map["created"])
      assertEquals("Sun Dec 17 04:33:45 2023", map["expires"])
      assertEquals("No", map["destroy_after_download"])
      assertEquals("No", map["onion_only"])
      assertEquals("0/1000", map["hits"])
      assertEquals("https://oshi.ec/a/2303ac72e6987a61ef73c504abb4e8d7f710e269/delete", map["delete_file"])
    }
}
