package org.codeberg.quecomet.oshi.utils

import android.Manifest
import android.app.NotificationManager
import android.content.Context
import android.os.Build
import androidx.core.app.NotificationChannelCompat
import androidx.core.app.NotificationManagerCompat
import org.codeberg.quecomet.oshi.R

private const val UPLOADWORK_NOTIF_TAG_PREFIX = "upload-work:"

fun getUploadWorkNotifTag(workUUID: String): String {
  return "$UPLOADWORK_NOTIF_TAG_PREFIX${workUUID}"
}

fun removeUploadProgressNotification(workUUID: String, context: Context) {
  NotificationManagerCompat.from(context)
      .cancel(getUploadWorkNotifTag(workUUID), R.id.notif_id_upload_progress)
}

fun isNotificationAllowed(context: Context, channelId: String? = null): Boolean {
  if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.TIRAMISU) {
    if (!isPermissionGranted(context, Manifest.permission.POST_NOTIFICATIONS)) return false
  }
  if (!NotificationManagerCompat.from(context).areNotificationsEnabled()) return false

  if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
    if (channelId == null) return true
    runCatching {
      val mgr = context.getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager
      val channel = mgr.getNotificationChannel(channelId)
      return channel.importance != NotificationManager.IMPORTANCE_NONE
    }
    return false
  } else {
    return false
  }
}

fun createNotificationChannels(context: Context) {
  val notifManager = NotificationManagerCompat.from(context)

  notifManager.createNotificationChannel(
      NotificationChannelCompat.Builder(
              context.getString(R.string.channel_id_upload_progress),
              NotificationManagerCompat.IMPORTANCE_LOW)
          .setLightsEnabled(false)
          .setVibrationEnabled(false)
          .setName(context.getString(R.string.channel_name_upload_progress))
          .build())
}
