package org.codeberg.quecomet.oshi.utils

import android.content.Context
import android.net.Uri
import android.provider.OpenableColumns
import java.io.IOException

fun getFileName(uri: Uri, context: Context): String {
  var result: String? = null
  if (uri.scheme == "content") {
    context.contentResolver.query(uri, null, null, null, null).use { cursor ->
      if (cursor != null && cursor.moveToFirst()) {
        val colIndex = cursor.getColumnIndex(OpenableColumns.DISPLAY_NAME)
        if (colIndex != -1) {
          result = cursor.getString(colIndex)
        }
      }
    }
  }
  if (result == null) {
    result = uri.path
    val cut = result!!.lastIndexOf('/')
    if (cut != -1) {
      result = result!!.substring(cut + 1)
    }
  }
  return result!!
}

fun getFileSize(uri: Uri, context: Context): Long {
  var result: Long? = null
  context.contentResolver.query(uri, null, null, null, null).use { cursor ->
    if (cursor != null && cursor.moveToFirst()) {
      val colIndex = cursor.getColumnIndex(OpenableColumns.SIZE)
      if (colIndex != -1) {
        result = cursor.getLong(colIndex)
      }
    }
  }
  if (result == null) throw IOException("cannot retrieve file size for $uri")
  return result!!
}
