package org.codeberg.quecomet.oshi.utils

import android.content.ClipData
import android.content.ClipboardManager
import android.content.Context
import androidx.annotation.StringRes
import androidx.compose.material3.SnackbarDuration
import org.codeberg.quecomet.oshi.R
import org.codeberg.quecomet.oshi.model.SnackbarMessage
import org.codeberg.quecomet.oshi.model.UserMessage
import org.codeberg.quecomet.oshi.ui.components.SnackbarManager

fun copyToClipboard(
  context: Context,
  text: String,
  label: String? = null,
  @StringRes confirmationMessage: Int? = R.string.copied,
) {
  val clipboard = context.getSystemService(Context.CLIPBOARD_SERVICE) as ClipboardManager
  clipboard.setPrimaryClip(ClipData.newPlainText(label ?: "", text))
  if (confirmationMessage != null) {
    SnackbarManager.showMessage(
        SnackbarMessage.from(
            message = UserMessage.from(confirmationMessage),
            withDismissAction = true,
            duration = SnackbarDuration.Short,
        ))
  }
}
