package org.codeberg.quecomet.oshi.ui.screens.upload.components

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.padding
import androidx.compose.material3.Card
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Text
import androidx.compose.material3.TextButton
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.dimensionResource
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import org.codeberg.quecomet.oshi.R
import org.codeberg.quecomet.oshi.ui.components.BasicDialog

@Composable
fun NotificationPermissionDialog(
    modifier: Modifier = Modifier,
    onResult: () -> Unit,
) {
  BasicDialog(onDismissRequest = {}) {
    Card() {
      Column(
          horizontalAlignment = Alignment.CenterHorizontally,
          verticalArrangement = Arrangement.spacedBy(10.dp),
          modifier = modifier.padding(dimensionResource(R.dimen.padding_lg)),
      ) {
        Text(
            text = stringResource(R.string.title_notifications),
            style = MaterialTheme.typography.titleMedium,
        )
        Text(
            stringResource(R.string.dialog_notification_permission),
            modifier = Modifier.padding(dimensionResource(R.dimen.padding_sm)),
            textAlign = TextAlign.Justify,
        )

        Row(horizontalArrangement = Arrangement.spacedBy(dimensionResource(R.dimen.padding_md))) {
          TextButton(onClick = { onResult() }) {
            Text(
                stringResource(R.string.okay),
                color = MaterialTheme.colorScheme.onSurface,
            )
          }
        }
      }
    }
  }
}

@Preview(showBackground = true, widthDp = 300, locale = "en")
@Composable
fun NotificationPermissionDialogPreview() {
  NotificationPermissionDialog(
      onResult = {},
  )
}
