package org.codeberg.quecomet.oshi.ui.components

import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.padding
import androidx.compose.material3.BasicAlertDialog
import androidx.compose.material3.CircularProgressIndicator
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.OutlinedButton
import androidx.compose.material3.Surface
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.res.dimensionResource
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.window.DialogProperties
import org.codeberg.quecomet.oshi.R
import org.codeberg.quecomet.oshi.ui.theme.OshiTheme
import org.codeberg.quecomet.oshi.ui.utils.noRippleClickable

@OptIn(ExperimentalMaterial3Api::class)
@Composable
fun WorkingDialog(
    onDismissRequest: () -> Unit = {},
    showCancelButton: Boolean = true,
    text: @Composable () -> Unit = {}
) {
  BasicAlertDialog(
      onDismissRequest = { onDismissRequest() },
      modifier =
          Modifier.fillMaxSize().background(Color.Black.copy(alpha = 0.5f)).noRippleClickable {
            // do nothing
          },
      properties =
          DialogProperties(usePlatformDefaultWidth = false, decorFitsSystemWindows = false),
  ) {
    Box(
        contentAlignment = Alignment.Center,
        modifier = Modifier.padding(dimensionResource(R.dimen.padding_xl))) {
          Card {
            Column(
                verticalArrangement = Arrangement.spacedBy(dimensionResource(R.dimen.padding_xl)),
                horizontalAlignment = Alignment.CenterHorizontally,
                modifier = Modifier.padding(dimensionResource(R.dimen.padding_xl)),
            ) {
              text()
              CircularProgressIndicator()
              if (showCancelButton) {
                OutlinedButton(onClick = { onDismissRequest() }) {
                  Text(stringResource(R.string.cancel))
                }
              }
            }
          }
        }
  }
}

@Preview("Confirm Dialog")
@Composable
fun ConfirmFingerprintDialogPreview() {
  OshiTheme { Surface { WorkingDialog() } }
}
