package org.codeberg.quecomet.oshi.model.api

import androidx.compose.runtime.Immutable

@Immutable
data class UploadFileCurlResponse(
    val manageUrl: String,
    val downloadUrl: String,
)

fun parseUploadFileCurlResponse(response: String): UploadFileCurlResponse {
  val map = parseCurlResponse(response)
  return UploadFileCurlResponse(
      manageUrl = map["manage"] ?: throw RuntimeException("could not extract manage url from upload response"),
      downloadUrl = map["dl"] ?: throw RuntimeException("could not extract manage url from upload response"),
  )
}
