package org.codeberg.quecomet.oshi.model.api

val mapRegex = """([\w\s]+):\s*(.*)""".toRegex()

fun parseCurlResponse(response: String): MutableMap<String, String> {
  val parsedData = mutableMapOf<String, String>()
  mapRegex.findAll(response).forEach {
    if (it.groups.size == 3) {
      parsedData[it.groups[1]!!.value.trim().lowercase().replace(' ', '_')] = it.groups[2]!!.value.trim()
    }
  }
  return parsedData
}
