package org.codeberg.quecomet.oshi.data.room.typeconverters

import androidx.room.TypeConverter
import io.ktor.http.URLProtocol

object URLProtocolTypeConverter {
  @TypeConverter
  @JvmStatic
  fun fromString(value: String?): URLProtocol? {
    return value?.let { URLProtocol.createOrDefault(it) }
  }

  @TypeConverter
  @JvmStatic
  fun URLProtocolToString(urlProtocol: URLProtocol?): String? {
    return urlProtocol?.name
  }
}
