package org.codeberg.quecomet.oshi.data

import androidx.compose.runtime.Stable
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.first
import kotlinx.coroutines.flow.flow
import org.codeberg.quecomet.oshi.PreferredProxyType
import org.codeberg.quecomet.oshi.SSLCheckMode
import org.codeberg.quecomet.oshi.UserSettings

@Stable
class UserSettingsRepositoryMock(
    private val userSettings: UserSettings = UserSettings.getDefaultInstance()
) : UserSettingsRepository {

  override val userSettingsFlow: Flow<UserSettings> = flow { emit(userSettings) }

  override suspend fun fetchSettings() = userSettingsFlow.first()

  override suspend fun saveSettings(userSettings: UserSettings) {}

  override suspend fun setFirstInitDone(value: Boolean) {}

  override suspend fun setIsProxyEnabled(value: Boolean) {}

  override suspend fun setProxyHost(value: String) {}

  override suspend fun setProxyPort(value: String) {}

  override suspend fun setPreferredProxyType(value: PreferredProxyType) {}

  override suspend fun setSelectedOshiInstance(value: Int) {}

  override suspend fun setSSLCheckMode(value: SSLCheckMode) {}

  override suspend fun setUploadExpiration(value: Int) {}

  override suspend fun setUploadDestroyAfterDL(value: Boolean) {}

  override suspend fun setUploadRandomizeName(value: Boolean) {}

  override suspend fun setUploadShortenUrl(value: Boolean) {}

  override suspend fun setHasShownNotificationPermissionRequest(value: Boolean) {}
}
