package org.codeberg.quecomet.oshi.data

import androidx.compose.runtime.Stable
import androidx.paging.PagingData
import kotlinx.collections.immutable.persistentListOf
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import org.codeberg.quecomet.oshi.data.room.UploadedFile
import org.codeberg.quecomet.oshi.data.room.UploadedFileAndOshiInstance

@Stable
class UploadedFileRepositoryMock : UploadedFileRepository {

  companion object {

    val files =
        persistentListOf(
            UploadedFile(
                managePath = "aca56d351b421c8bdd80ed8367f1cf364b77aafd",
                downloadPath = "GnEfD/dadsadsadsa.txt",
                destroyAfterDl = true,
                deletedInRemote = false,
                isOnionOnly = false,
                filename = "GnEfD/dadsadsadsasdsadasdasdasda.txt",
                originalFilename = "foo.txt",
                size = 0,
                mimeType = "text/plain",
                oshiInstanceId = 1,
            ),
        )

    val filesAndOshiInstances =
        persistentListOf(
            UploadedFileAndOshiInstance(
                uploadedFile = files[0],
                oshiInstance = OshiInstanceRepositoryMock.instances[0],
            ))
  }

  override suspend fun insertUploadedFile(uploadedFile: UploadedFile) {}

  override suspend fun getUploadedFileAndOshiInstance(
      managePath: String,
      oshiInstanceId: Int
  ): UploadedFileAndOshiInstance {
    return filesAndOshiInstances[0]
  }

  override fun getUploadedFileAndOshiInstanceFlow(
      managePath: String,
      oshiInstanceId: Int
  ): Flow<UploadedFileAndOshiInstance?> {
    return flow { emit(filesAndOshiInstances[0]) }
  }

  override fun getUploadedFileAndOshiInstanceList(
      searchTerm: String,
      pageSize: Int
  ): Flow<PagingData<UploadedFileAndOshiInstance>> {
    return flow {
      emit(
          PagingData.from(filesAndOshiInstances),
      )
    }
  }

  override suspend fun count(): Int {
    return files.size
  }

  override suspend fun deleteRemote(managePath: String, oshiInstanceId: Int) {}

  override suspend fun deleteLocal(managePath: String, oshiInstanceId: Int) {}

  override suspend fun delete(managePath: String, oshiInstanceId: Int) {}

  override suspend fun fetchUploadedFile(managePath: String, oshiInstanceId: Int) {}

  override suspend fun toggleDestroyAfterDl(managePath: String, oshiInstanceId: Int) {}

  override suspend fun toggleOnionOnly(managePath: String, oshiInstanceId: Int) {}
}
