package org.codeberg.quecomet.oshi.data

import androidx.compose.runtime.Stable
import androidx.paging.PagingData
import kotlinx.coroutines.flow.Flow
import org.codeberg.quecomet.oshi.data.room.UploadedFile
import org.codeberg.quecomet.oshi.data.room.UploadedFileAndOshiInstance

@Stable
interface UploadedFileRepository {

  suspend fun insertUploadedFile(uploadedFile: UploadedFile)

  suspend fun getUploadedFileAndOshiInstance(
      managePath: String,
      oshiInstanceId: Int
  ): UploadedFileAndOshiInstance?

  fun getUploadedFileAndOshiInstanceFlow(
      managePath: String,
      oshiInstanceId: Int
  ): Flow<UploadedFileAndOshiInstance?>

  fun getUploadedFileAndOshiInstanceList(
      searchTerm: String = "",
      pageSize: Int = 10
  ): Flow<PagingData<UploadedFileAndOshiInstance>>

  suspend fun count(): Int

  suspend fun deleteRemote(managePath: String, oshiInstanceId: Int)

  suspend fun deleteLocal(managePath: String, oshiInstanceId: Int)

  suspend fun delete(managePath: String, oshiInstanceId: Int)

  suspend fun fetchUploadedFile(managePath: String, oshiInstanceId: Int)

  suspend fun toggleDestroyAfterDl(managePath: String, oshiInstanceId: Int)

  suspend fun toggleOnionOnly(managePath: String, oshiInstanceId: Int)
}
