package org.codeberg.quecomet.oshi.data

import androidx.compose.runtime.Stable
import androidx.paging.PagingData
import androidx.work.WorkInfo
import kotlinx.collections.immutable.persistentListOf
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import org.codeberg.quecomet.oshi.data.room.PreparedUploadWork
import org.codeberg.quecomet.oshi.data.room.UploadWork
import org.codeberg.quecomet.oshi.data.room.UploadWorkAndOshiInstance

@Stable
class UploadWorkRepositoryMock(private val hasItems: Boolean = true) : UploadWorkRepository {

  companion object {

    val works =
        persistentListOf(
            UploadWork(
                workUUID = "aca56d351b421c8bdd80ed8367f1cf364b77aafd",
                oshiInstanceId = 1,
                filename = "foo.txt",
                fileUri = "content://com.android.xyz/xyz/foobar:44000/foo.txt",
                retriedWithOshiInstanceIds = "1",
            ),
            UploadWork(
                workUUID = "bca56d351b421c8bdd80ed8367f1cf364b77aafc",
                oshiInstanceId = 1,
                filename = "a_file_with_a_quite_long_name_for_test_in_ui.txt",
                fileUri =
                    "content://com.android.xyz/xyz/foobar:64844/a_file_with_a_quite_long_name_for_test_in_ui.txt",
                retriedWithOshiInstanceIds = "1",
            ),
        )

    val worksAndInstances =
        works.map { UploadWorkAndOshiInstance(it, OshiInstanceRepositoryMock.instances[0]) }
  }

  override suspend fun createWork(preparedUploadWork: PreparedUploadWork) {}

  override suspend fun getUploadWork(workUUID: String): UploadWork? {
    return if (hasItems) {
      works[0]
    } else {
      null
    }
  }

  override suspend fun getUploadWorkAndOshiInstance(workUUID: String): UploadWorkAndOshiInstance? {
    return worksAndInstances[0]
  }

  override fun getUploadWorkAndOshiInstanceList(
      pageSize: Int
  ): Flow<PagingData<UploadWorkAndOshiInstance>> {
    return flow {
      emit(
          PagingData.from(
              if (hasItems) {
                worksAndInstances
              } else {
                emptyList()
              }),
      )
    }
  }

  override fun getUploadWorkWorkInfo(workUUID: String?): Flow<WorkInfo?> {
    return flow { emit(null) }
  }

  override fun retry(workUUID: String) {}

  override suspend fun retryDifferentInstance(workUUID: String) {}

  override suspend fun changeInstance(workUUID: String, newOshiInstanceId: Int) {}

  override suspend fun delete(workUUID: String) {}

  override fun cancel(workUUID: String) {}

  override suspend fun setCanRetry(workUUID: String, canRetry: Boolean) {}
}
