package org.codeberg.quecomet.oshi.data

import androidx.compose.runtime.Stable
import androidx.paging.PagingData
import kotlinx.coroutines.flow.Flow
import org.codeberg.quecomet.oshi.data.room.OshiInstance

@Stable
interface OshiInstanceRepository {

  fun getInstanceFlow(id: Int): Flow<OshiInstance?>

  fun getInstanceList(searchTerm: String = "", pageSize: Int = 10): Flow<PagingData<OshiInstance>>

  suspend fun getInstance(id: Int): OshiInstance?

  suspend fun getFirstInstance(): OshiInstance?

  suspend fun addInstance(instance: OshiInstance)

  suspend fun delete(id: Int)

  suspend fun updateInstance(instance: OshiInstance)
}
