package org.codeberg.quecomet.oshi

import android.content.Context
import android.net.Uri
import androidx.core.content.FileProvider
import java.io.File

@Throws(Exception::class)
fun Context.createFileInCacheAndGetUri(text: String, fileName: String): Uri? {
  val file = File(cacheDir, fileName)
  file.writeText(text)
  return FileProvider.getUriForFile(this, "${applicationContext.packageName}.provider", file)
}
