package org.codeberg.quecomet.oshi

import org.codeberg.quecomet.oshi.model.api.parseOshiDate
import org.junit.Assert.assertEquals
import org.junit.Assert.assertNotNull
import org.junit.Test
import java.time.DayOfWeek
import java.time.Month

class OshiDateParseTest {
  @Test
  fun parsingOshiDatesWorks() {
    val parsedDate = parseOshiDate("Sat Dec 16 04:33:45 2023")!!

    assertNotNull(parsedDate)
    assertEquals(Month.DECEMBER, parsedDate.month)
    assertEquals(DayOfWeek.SATURDAY, parsedDate.dayOfWeek)
    assertEquals(16, parsedDate.dayOfMonth)
  }
}
