package org.codeberg.quecomet.oshi.ui.components

import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.padding
import androidx.compose.material3.Checkbox
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Surface
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import org.codeberg.quecomet.oshi.ui.theme.OshiTheme

@Composable
fun CheckBoxRow(
    modifier: Modifier = Modifier,
    checked: Boolean,
    onCheckedChange: (Boolean) -> Unit,
    enabled: Boolean = true,
    text: @Composable () -> Unit,
) {
  Surface(
      modifier = modifier,
      onClick = { onCheckedChange(!checked) },
      enabled = enabled,
      shape = MaterialTheme.shapes.small,
      color = Color.Transparent) {
        Row(
            modifier = Modifier.padding(end = 14.dp),
            verticalAlignment = Alignment.CenterVertically,
        ) {
          Checkbox(checked = checked, onCheckedChange = onCheckedChange, enabled = enabled)
          text()
        }
      }
}

@Preview("default")
@Composable
fun CheckBoxRowPreview() {
  OshiTheme {
    CheckBoxRow(
        checked = true,
        text = { Text("test") },
        onCheckedChange = {},
    )
  }
}
