package org.codeberg.quecomet.oshi.ui.components

import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.padding
import androidx.compose.material3.BasicAlertDialog
import androidx.compose.material3.Card
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.res.dimensionResource
import androidx.compose.ui.window.DialogProperties
import org.codeberg.quecomet.oshi.R
import org.codeberg.quecomet.oshi.ui.utils.noRippleClickable

@OptIn(ExperimentalMaterial3Api::class)
@Composable
fun BasicDialog(
    modifier: Modifier = Modifier,
    onDismissRequest: () -> Unit,
    content: @Composable () -> Unit,
) {
  BasicAlertDialog(
      onDismissRequest = onDismissRequest,
      modifier = Modifier.fillMaxSize().background(Color.Black.copy(alpha = 0.5f)),
      properties =
          DialogProperties(usePlatformDefaultWidth = false, decorFitsSystemWindows = false),
  ) {
    Box(
        contentAlignment = Alignment.Center,
        modifier =
            Modifier.noRippleClickable { onDismissRequest() }
                .padding(dimensionResource(R.dimen.padding_xl)),
    ) {
      Card(modifier = modifier.noRippleClickable {}) { content() }
    }
  }
}
