package org.codeberg.quecomet.oshi.ui.components

import androidx.compose.animation.core.FastOutSlowInEasing
import androidx.compose.animation.core.animateFloatAsState
import androidx.compose.animation.core.tween
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material3.LinearProgressIndicator
import androidx.compose.runtime.Composable
import androidx.compose.runtime.LaunchedEffect
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableFloatStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.clip
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import org.codeberg.quecomet.oshi.ui.theme.OshiTheme

/** progress value must be between 0f and 1f */
@Composable
fun AnimatedLinearProgressIndicator(
    indicatorProgress: Float,
    indeterminate: Boolean = false,
) {

  var progress by remember { mutableFloatStateOf(0f) }
  val progressAnimDuration = 1000
  val progressAnimation by
      animateFloatAsState(
          targetValue = indicatorProgress,
          animationSpec =
              tween(durationMillis = progressAnimDuration, easing = FastOutSlowInEasing),
          label = "linear progress indicator animation")
  if (indeterminate) {
    LinearProgressIndicator(
        modifier = Modifier.fillMaxWidth().clip(RoundedCornerShape(5.dp)), // Rounded edges
    )
  } else {
    LinearProgressIndicator(
        modifier = Modifier.fillMaxWidth().clip(RoundedCornerShape(5.dp)), // Rounded edges
        progress = { progressAnimation })
  }

  LaunchedEffect(indicatorProgress) { progress = indicatorProgress }
}

@Preview("default")
@Composable
fun AnimatedLinearProgressIndicatorPreview() {
  OshiTheme(darkTheme = true) { AnimatedLinearProgressIndicator(0.5f) }
}
