package org.codeberg.quecomet.oshi.network

import java.security.MessageDigest
import java.security.cert.X509Certificate

fun X509Certificate.getSha256Fingerprint(): String {
  val md = MessageDigest.getInstance("SHA-256")
  md.update(this.encoded)
  return bytesToHex(md.digest())
}

fun X509Certificate.getSha1Fingerprint(): String {
  val md = MessageDigest.getInstance("SHA-1")
  md.update(this.encoded)
  return bytesToHex(md.digest())
}

private fun bytesToHex(bytes: ByteArray): String {
  val hexChars = "0123456789ABCDEF"
  val result = StringBuilder(bytes.size * 2)
  for (byte in bytes) {
    val intVal = byte.toInt() and 0xff
    result.append(hexChars[intVal ushr 4])
    result.append(hexChars[intVal and 0x0f])
    result.append(":")
  }
  // delete the last colon
  if (result.lastIndex != -1) result.deleteCharAt(result.lastIndex)
  return result.toString()
}
