package org.codeberg.quecomet.oshi.network

import android.annotation.SuppressLint
import androidx.compose.runtime.Stable
import org.codeberg.quecomet.oshi.network.exceptions.FingerprintDetectedException
import java.security.cert.X509Certificate
import javax.inject.Inject
import javax.inject.Singleton
import javax.net.ssl.X509TrustManager

@SuppressLint("CustomX509TrustManager")
@Singleton
@Stable
class FingerprintTrustManager @Inject constructor() : X509TrustManager {

  override fun checkClientTrusted(chain: Array<out X509Certificate>?, authType: String?) {
    throw RuntimeException("Not supposed to be run")
  }

  override fun checkServerTrusted(chain: Array<out X509Certificate>?, authType: String?) {
    if (chain == null || chain.isEmpty())
        throw IllegalArgumentException("Certificate chain is empty")

    val sha1Fingerprint = chain[0].getSha1Fingerprint()
    val sha256Fingerprint = chain[0].getSha256Fingerprint()

    throw FingerprintDetectedException(sha1Fingerprint, sha256Fingerprint)
  }

  override fun getAcceptedIssuers(): Array<X509Certificate> {
    return arrayOf()
  }
}
