package org.codeberg.quecomet.oshi.exceptions

import androidx.annotation.StringRes
import org.codeberg.quecomet.oshi.model.Translatable
import org.codeberg.quecomet.oshi.model.UserMessage
import javax.annotation.concurrent.Immutable

@Immutable
open class LocalizedException(
    @StringRes override val translation: Int? = null,
    override val message: String? = null,
) : Exception(), Translatable

fun Throwable.toUserMessage(): UserMessage {
  return if (this is LocalizedException && this.translation != null) UserMessage.from(this.translation!!)
  else UserMessage.from(this.localizedMessage ?: this.message ?: this.toString())
}
