package org.codeberg.quecomet.oshi.di

import android.content.Context
import androidx.room.Room
import dagger.Module
import dagger.Provides
import dagger.hilt.InstallIn
import dagger.hilt.android.qualifiers.ApplicationContext
import dagger.hilt.components.SingletonComponent
import org.codeberg.quecomet.oshi.data.room.OshiDatabase
import javax.inject.Singleton

@Module
@InstallIn(SingletonComponent::class)
class DatabaseModule {

  @Provides
  @Singleton
  fun provideOshiDatabase(@ApplicationContext context: Context): OshiDatabase {
    return Room.databaseBuilder(
        context,
        OshiDatabase::class.java,
        "data.db",
    )
        .fallbackToDestructiveMigration()
        .build()
  }
}
