package org.codeberg.quecomet.oshi.data.room

import androidx.paging.PagingSource
import androidx.room.Dao
import androidx.room.OnConflictStrategy
import androidx.room.Query
import androidx.room.Transaction
import androidx.room.Update

/** [Room] DAO for [UploadWork] related operations. */
@Dao
abstract class UploadWorkDao : BaseDao<UploadWork> {
  @Query("SELECT * FROM `UploadWork` WHERE workUUID = :workUUID")
  abstract suspend fun uploadWorkByUUID(workUUID: String): UploadWork?

  @Transaction
  @Query("SELECT * FROM `UploadWork` WHERE workUUID = :workUUID")
  abstract suspend fun uploadWorkAndOshiInstanceByUUID(workUUID: String): UploadWorkAndOshiInstance?

  @Transaction
  @Query("SELECT * FROM `UploadWork` ORDER BY createdAt DESC")
  abstract fun uploadWorkAndOshiInstanceSortedByCreatedAtPagingSource(): PagingSource<Int, UploadWorkAndOshiInstance>

  @Query("DELETE FROM `UploadWork` WHERE workUUID = :workUUID")
  abstract suspend fun delete(workUUID: String)

  @Update(onConflict = OnConflictStrategy.REPLACE, entity = UploadWork::class)
  abstract suspend fun setCanRetry(entity: UploadWorkWithRetry)
}
