package org.codeberg.quecomet.oshi.data.room

import androidx.compose.runtime.Stable
import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.Index
import androidx.room.PrimaryKey
import io.ktor.http.URLProtocol
import java.util.Date

@Stable
@Entity(
    indices = [Index("createdAt"), Index("host", "protocol", unique = true)],
)
data class OshiInstance(
    @PrimaryKey(autoGenerate = true) val id: Int = 0,
    /** the user defined label for this org.codeberg.quecomet.oshi instance */
    val label: String,
    val host: String,
    val protocol: URLProtocol,
    @ColumnInfo(defaultValue = "null") val alternateHost: String? = null,
    val alternateProtocol: URLProtocol = URLProtocol.HTTPS,
    @ColumnInfo(defaultValue = "null") val sha1Fingerprint: String? = null,
    @ColumnInfo(defaultValue = "null") val sha256Fingerprint: String? = null,
    @ColumnInfo(defaultValue = "0") val fingerprintConfirmedByUser: Boolean = false,
    @ColumnInfo(defaultValue = CURRENT_TIMESTAMP_EXPRESSION) val createdAt: Date = Date(),
) {

  override fun toString(): String {
    return label.ifBlank { "${protocol.name}://${host}" }
  }
}
