package org.codeberg.quecomet.oshi.data.room

import androidx.room.AutoMigration
import androidx.room.Database
import androidx.room.RoomDatabase
import androidx.room.TypeConverters
import org.codeberg.quecomet.oshi.data.room.typeconverters.DateTimeTypeConverters
import org.codeberg.quecomet.oshi.data.room.typeconverters.URLProtocolTypeConverter

/** The [RoomDatabase] we use in this app. */
@Database(
    entities =
        [
            UploadedFile::class,
            OshiInstance::class,
            UploadWork::class,
        ],
    autoMigrations =
        [
            AutoMigration(from = 1, to = 2),
        ],
    version = 2,
    exportSchema = true,
)
@TypeConverters(
    DateTimeTypeConverters::class,
    URLProtocolTypeConverter::class,
)
abstract class OshiDatabase : RoomDatabase() {
  abstract fun uploadedFilesDao(): UploadedFileDao

  abstract fun uploadWorkDao(): UploadWorkDao

  abstract fun oshiInstancesDao(): OshiInstanceDao
}
