package org.codeberg.quecomet.oshi.data

import androidx.compose.runtime.Stable
import kotlinx.coroutines.flow.Flow
import org.codeberg.quecomet.oshi.PreferredProxyType
import org.codeberg.quecomet.oshi.SSLCheckMode
import org.codeberg.quecomet.oshi.UserSettings

@Stable
interface UserSettingsRepository {
  /** exposed flow to the user settings datastore */
  val userSettingsFlow: Flow<UserSettings>
  suspend fun fetchSettings(): UserSettings
  suspend fun saveSettings(userSettings: UserSettings)
  suspend fun setFirstInitDone(value: Boolean)
  suspend fun setIsProxyEnabled(value: Boolean)
  suspend fun setProxyHost(value: String)
  suspend fun setProxyPort(value: String)
  suspend fun setPreferredProxyType(value: PreferredProxyType)
  suspend fun setSelectedOshiInstance(value: Int)
  suspend fun setSSLCheckMode(value: SSLCheckMode)
  suspend fun setUploadExpiration(value: Int)
  suspend fun setUploadDestroyAfterDL(value: Boolean)
  suspend fun setUploadRandomizeName(value: Boolean)
  suspend fun setUploadShortenUrl(value: Boolean)
  suspend fun setHasShownNotificationPermissionRequest(value: Boolean)
}
