package org.codeberg.quecomet.oshi.data

import androidx.compose.runtime.Stable
import androidx.paging.PagingData
import androidx.work.WorkInfo
import kotlinx.coroutines.flow.Flow
import org.codeberg.quecomet.oshi.data.room.PreparedUploadWork
import org.codeberg.quecomet.oshi.data.room.UploadWork
import org.codeberg.quecomet.oshi.data.room.UploadWorkAndOshiInstance

@Stable
interface UploadWorkRepository {

  suspend fun createWork(preparedUploadWork: PreparedUploadWork)

  suspend fun getUploadWork(workUUID: String): UploadWork?

  suspend fun getUploadWorkAndOshiInstance(workUUID: String): UploadWorkAndOshiInstance?

  fun getUploadWorkAndOshiInstanceList(
      pageSize: Int = 10
  ): Flow<PagingData<UploadWorkAndOshiInstance>>

  fun getUploadWorkWorkInfo(workUUID: String?): Flow<WorkInfo?>

  fun retry(workUUID: String)

  suspend fun retryDifferentInstance(workUUID: String)

  suspend fun changeInstance(workUUID: String, newOshiInstanceId: Int)

  suspend fun delete(workUUID: String)

  fun cancel(workUUID: String)

  suspend fun setCanRetry(workUUID: String, canRetry: Boolean)
}
