package org.codeberg.quecomet.oshi

import android.content.Intent
import androidx.compose.runtime.Stable
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.update
import javax.inject.Inject
import javax.inject.Singleton

@Singleton
@Stable
class ShareIntentHandler @Inject constructor() {
  val shareEvent = MutableStateFlow<ShareEvent>(ShareEvent.None)

  fun handleShareIntent(intent: Intent?) {
    if (intent != null) {
      // make a copy
      val newIntent = Intent(intent)
      // this is to remove the FLAG_ACTIVITY_NEW_TASK flag, because navigation bugs otherwise
      newIntent.flags = Intent.FLAG_ACTIVITY_SINGLE_TOP and Intent.FLAG_ACTIVITY_CLEAR_TOP

      shareEvent.update { ShareEvent.HandleShareData(newIntent) }
    }
  }

  fun consumeEvent() {
    shareEvent.update { ShareEvent.None }
  }
}

sealed interface ShareEvent {

  @Stable data class HandleShareData(val intent: Intent) : ShareEvent

  object None : ShareEvent
}
