package org.codeberg.quecomet.oshi

import android.content.Context
import androidx.compose.runtime.Stable
import androidx.work.ExistingWorkPolicy
import androidx.work.OneTimeWorkRequestBuilder
import androidx.work.Operation
import androidx.work.OutOfQuotaPolicy
import androidx.work.WorkInfo
import androidx.work.WorkManager
import dagger.hilt.android.qualifiers.ApplicationContext
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.map
import org.codeberg.quecomet.oshi.worker.UploadFileWorker
import javax.inject.Inject
import javax.inject.Singleton

@Stable
@Singleton
class OshiWorkManager
@Inject
constructor(
    @ApplicationContext private val context: Context,
) {

  /** do not call this directly. use UploadWorkRepository instead */
  fun createUploadWork(uploadWorkUUID: String): Operation {
    return WorkManager.getInstance(context)
        .enqueueUniqueWork(
            uploadWorkUUID,
            ExistingWorkPolicy.REPLACE,
            OneTimeWorkRequestBuilder<UploadFileWorker>()
                .addTag(uploadWorkUUID)
                .setExpedited(OutOfQuotaPolicy.DROP_WORK_REQUEST)
                .build())
  }

  /** do not call this directly. use UploadWorkRepository instead */
  fun getUploadWorkWorkInfo(workUUID: String?): Flow<WorkInfo?> {
    return WorkManager.getInstance(context)
        .getWorkInfosByTagFlow(workUUID ?: "non-existing-tag-to-retrieve-nothing")
        .map { it.firstOrNull() }
  }

  /** do not call this directly. use UploadWorkRepository instead */
  fun cancelWork(workUUID: String): Operation {
    return WorkManager.getInstance(context).cancelAllWorkByTag(workUUID)
  }
}
