package org.codeberg.quecomet.oshi

import android.annotation.SuppressLint
import android.content.Context
import android.content.Intent
import android.util.Log
import androidx.work.impl.utils.ForceStopRunnable.BroadcastReceiver
import dagger.hilt.android.AndroidEntryPoint
import kotlinx.coroutines.DelicateCoroutinesApi
import kotlinx.coroutines.GlobalScope
import kotlinx.coroutines.launch
import org.codeberg.quecomet.oshi.data.UploadWorkRepository
import org.codeberg.quecomet.oshi.utils.copyToClipboard
import javax.inject.Inject

private const val TAG = "MyNotificationActionReceiver"

const val ACTION_CANCEL_UPLOAD = "org.codeberg.quecomet.oshi.cancel_upload"
const val ACTION_RETRY_UPLOAD = "org.codeberg.quecomet.oshi.retry_upload"
const val ACTION_RETRY_UPLOAD_DIFFERENT_INSTANCE =
    "org.codeberg.quecomet.oshi.retry_upload_different_instance"
const val ACTION_COPY_LINK = "org.codeberg.quecomet.oshi.copy_link"
const val ACTION_COPY_ONION_LINK = "org.codeberg.quecomet.oshi.copy_onion_link"

@SuppressLint("RestrictedApi")
@AndroidEntryPoint
class MyNotificationActionReceiver : BroadcastReceiver() {

  @Inject lateinit var oshiUploadWorkRepository: UploadWorkRepository

  @OptIn(DelicateCoroutinesApi::class)
  override fun onReceive(context: Context, intent: Intent?) {
    super.onReceive(context, intent)

    when (intent?.action) {
      ACTION_CANCEL_UPLOAD -> {
        val workUUID =
            intent.getStringExtra("workUUID")
                ?: throw IllegalArgumentException(
                    "workUUID was not passed by ACTION_CANCEL_UPLOAD intent")
        oshiUploadWorkRepository.cancel(workUUID)
      }
      ACTION_RETRY_UPLOAD -> {
        val workUUID =
            intent.getStringExtra("workUUID")
                ?: throw IllegalArgumentException(
                    "workUUID was not passed by ACTION_CANCEL_UPLOAD intent")
        oshiUploadWorkRepository.retry(workUUID)
      }
      ACTION_RETRY_UPLOAD_DIFFERENT_INSTANCE -> {
        val workUUID =
            intent.getStringExtra("workUUID")
                ?: throw IllegalArgumentException(
                    "workUUID was not passed by ACTION_CANCEL_UPLOAD intent")
        GlobalScope.launch {
          try {
            oshiUploadWorkRepository.retryDifferentInstance(workUUID)
          } catch (e: Throwable) {
            Log.d(TAG, e.toString())
          }
        }
      }
      ACTION_COPY_LINK -> {
        copyToClipboard(
            context,
            intent.getStringExtra("link")
                ?: throw IllegalArgumentException("link was not passed by ACTION_COPY_LINK intent"))
      }
      ACTION_COPY_ONION_LINK -> {
        copyToClipboard(
            context,
            intent.getStringExtra("onionLink")
                ?: throw IllegalArgumentException(
                    "onionLink was not passed by ACTION_COPY_ONION_LINK intent"))
      }
    }
  }
}
