package org.codeberg.quecomet.oshi

import androidx.compose.material3.windowsizeclass.WindowHeightSizeClass
import androidx.compose.material3.windowsizeclass.WindowSizeClass
import androidx.compose.material3.windowsizeclass.WindowWidthSizeClass
import androidx.compose.runtime.Composable
import org.codeberg.quecomet.oshi.ui.navigation.OshiNavHost
import org.codeberg.quecomet.oshi.ui.navigation.OshiNavigationContentPosition
import org.codeberg.quecomet.oshi.ui.navigation.OshiNavigationType
import org.codeberg.quecomet.oshi.ui.theme.OshiTheme

@Composable
fun MainCompose(
  windowSize: WindowSizeClass,
  deepLinkHandler: DeepLinkHandler,
) {
  /** This will help us select type of navigation depending on window size state of the device. */
  val navigationType: OshiNavigationType

  when (windowSize.widthSizeClass) {
    WindowWidthSizeClass.Compact -> {
      navigationType = OshiNavigationType.BOTTOM_NAVIGATION
    }

    WindowWidthSizeClass.Medium -> {
      navigationType = OshiNavigationType.NAVIGATION_RAIL
    }

    WindowWidthSizeClass.Expanded -> {
      navigationType = OshiNavigationType.PERMANENT_NAVIGATION_DRAWER
    }

    else -> {
      navigationType = OshiNavigationType.BOTTOM_NAVIGATION
    }
  }

  /**
   * Content inside Navigation Rail/Drawer can also be positioned at top, bottom or center for
   * ergonomics and reachability depending upon the height of the device.
   */
  val navigationContentPosition =
      when (windowSize.heightSizeClass) {
        WindowHeightSizeClass.Compact -> {
          OshiNavigationContentPosition.TOP
        }

        WindowHeightSizeClass.Medium,
        WindowHeightSizeClass.Expanded -> {
          OshiNavigationContentPosition.CENTER
        }

        else -> {
          OshiNavigationContentPosition.TOP
        }
      }

  OshiTheme { OshiNavHost(navigationType, navigationContentPosition, deepLinkHandler) }
}
