package org.codeberg.nykula.sapfir;

import android.Manifest;
import android.R;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build.VERSION;
import android.os.Bundle;
import android.util.Base64;
import android.util.Log;
import android.webkit.DownloadListener;
import android.webkit.JavascriptInterface;
import android.webkit.JsResult;
import android.webkit.PermissionRequest;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Toast;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContracts.StartActivityForResult;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.webkit.WebViewAssetLoader;
import java.io.IOException;
import java.io.OutputStream;

public class MainActivity extends AppCompatActivity {
  ActivityResultLauncher<Intent> createDocument;
  ActivityResultLauncher<Intent> fileChooser;
  ValueCallback<Uri[]> filePath;
  final int REQUEST_RECORD_AUDIO = 101;
  PermissionRequest permissionRequest;
  String sf2Base64;
  WebView webView;

  public class WebViewInterface {
    @JavascriptInterface
    public void downloadBase64(String base64, String name) {
      sf2Base64 = base64;
      Intent intent = new Intent(Intent.ACTION_CREATE_DOCUMENT);
      intent.addCategory(Intent.CATEGORY_OPENABLE);
      intent.setType("audio/x-sfbk");
      intent.putExtra(Intent.EXTRA_TITLE, name);
      createDocument.launch(intent);
    }

    @JavascriptInterface
    public int sdkInt() {
      return VERSION.SDK_INT;
    }
  }

  @Override
  @SuppressLint("SetJavaScriptEnabled")
  public void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);

    createDocument =
        registerForActivityResult(
            new StartActivityForResult(),
            result -> {
              if (result.getResultCode() == Activity.RESULT_OK) {
                try {
                  OutputStream output =
                      getContentResolver().openOutputStream(result.getData().getData());
                  output.write(Base64.decode(sf2Base64, 0));
                  output.close();
                  Toast.makeText(this, getString(R.string.ok), Toast.LENGTH_SHORT).show();
                } catch (IOException e) {
                  Log.e("sapfir", "exception", e);
                  Toast.makeText(this, e.getMessage(), Toast.LENGTH_SHORT).show();
                }
              }
              sf2Base64 = null;
            });

    fileChooser =
        registerForActivityResult(
            new StartActivityForResult(),
            result -> {
              if (filePath != null) {
                filePath.onReceiveValue(
                    WebChromeClient.FileChooserParams.parseResult(
                        result.getResultCode(), result.getData()));
                filePath = null;
              }
            });

    webView = new WebView(this);
    WebSettings settings = webView.getSettings();
    settings.setJavaScriptEnabled(true);
    settings.setCacheMode(WebSettings.LOAD_NO_CACHE);

    final WebViewAssetLoader assetLoader =
        new WebViewAssetLoader.Builder()
            .addPathHandler("/assets/", new WebViewAssetLoader.AssetsPathHandler(this))
            .build();
    webView.setWebViewClient(
        new WebViewClient() {
          @Override
          public WebResourceResponse shouldInterceptRequest(
              WebView view, WebResourceRequest request) {
            return assetLoader.shouldInterceptRequest(request.getUrl());
          }

          @Override
          public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
            if (request.getUrl().toString().contains("appassets.androidplatform.net")) {
              return false;
            }
            startActivity(new Intent(Intent.ACTION_VIEW, request.getUrl()));
            return true;
          }
        });

    webView.setWebChromeClient(
        new WebChromeClient() {
          @Override
          public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
            Toast.makeText(MainActivity.this, message, Toast.LENGTH_LONG).show();
            result.confirm();
            return true;
          }

          @Override
          public boolean onJsConfirm(WebView view, String url, String message, JsResult result) {
            new AlertDialog.Builder(MainActivity.this)
                .setMessage(message)
                .setPositiveButton(R.string.ok, (dialog, which) -> result.confirm())
                .setNegativeButton(R.string.cancel, (dialog, which) -> result.cancel())
                .setOnDismissListener((dialog) -> result.cancel())
                .create()
                .show();
            return true;
          }

          @Override
          public void onPermissionRequest(PermissionRequest request) {
            permissionRequest = request;

            for (String permission : request.getResources()) {
              switch (permission) {
                case "android.webkit.resource.AUDIO_CAPTURE":
                  if (ContextCompat.checkSelfPermission(
                          getApplicationContext(), Manifest.permission.RECORD_AUDIO)
                      == PackageManager.PERMISSION_GRANTED) {
                    permissionRequest.grant(permissionRequest.getResources());
                  } else {
                    ActivityCompat.requestPermissions(
                        MainActivity.this,
                        new String[] {Manifest.permission.RECORD_AUDIO},
                        REQUEST_RECORD_AUDIO);
                  }
                  break;
              }
            }
          }

          public boolean onShowFileChooser(
              WebView mWebView,
              ValueCallback<Uri[]> filePathCallback,
              WebChromeClient.FileChooserParams fileChooserParams) {
            if (filePath != null) {
              filePath.onReceiveValue(null);
              filePath = null;
            }
            filePath = filePathCallback;
            fileChooser.launch(fileChooserParams.createIntent());
            return true;
          }
        });

    webView.addJavascriptInterface(new WebViewInterface(), "Android");

    webView.setDownloadListener(
        new DownloadListener() {
          @Override
          public void onDownloadStart(
              String url,
              String userAgent,
              String contentDisposition,
              String mimetype,
              long contentLength) {
            if (url.startsWith("blob:")) {
              webView.loadUrl(
                  "javascript:(() => { const xhr = new XMLHttpRequest(); xhr.open('GET', '"
                      + url
                      + "', true); xhr.setRequestHeader('Content-Type',"
                      + " 'application/octet-stream'); xhr.responseType = 'blob'; xhr.onload ="
                      + " function(e) { const blob = this.response; const reader = new"
                      + " FileReader(); reader.readAsDataURL(blob); reader.onloadend = () => {"
                      + " Android.downloadBase64(reader.result.replace('data:application/octet-stream;base64,',"
                      + " ''), '"
                      + url
                      + "'.replace(/.+#/, '')); }; }; xhr.send(); })()");
            }
          }
        });

    webView.loadUrl("https://appassets.androidplatform.net/assets/index.html");
    setContentView(webView);
  }

  @Override
  public void onBackPressed() {
    if (webView.canGoBack()) {
      webView.goBack();
    } else {
      super.onBackPressed();
    }
  }

  @Override
  public void onRequestPermissionsResult(
      int requestCode, String permissions[], int[] grantResults) {
    switch (requestCode) {
      case REQUEST_RECORD_AUDIO:
        if (grantResults.length > 0 && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
          permissionRequest.grant(permissionRequest.getResources());
        }
    }
    super.onRequestPermissionsResult(requestCode, permissions, grantResults);
  }
}
