/*
 * Copyright (C) 2006-2020  Music Technology Group - Universitat Pompeu Fabra
 *
 * This file is part of Essentia
 *
 * Essentia is free software: you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License as published by the Free
 * Software Foundation (FSF), either version 3 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the Affero GNU General Public License
 * version 3 along with this program.  If not, see http://www.gnu.org/licenses/
 */

// NOTE: This source code is auto-generated.

#include "./includes/essentiajs.h"

// expose essentiajs class to js using embind wrappers
EMSCRIPTEN_BINDINGS(CLASS_EssentiaJS) { 
  // NOTE: The following code snippets are machine generated. Do not edit.
  class_<EssentiaJS>("EssentiaJS")
    .constructor<bool>()
    .property("version", &EssentiaJS::essentiaVersion)
    .property("algorithmNames", &EssentiaJS::algorithmNames)
    .function("shutdown", &EssentiaJS::shutdown)
    .function("FrameGenerator", &EssentiaJS::FrameGenerator)
    .function("MonoMixer", &EssentiaJS::MonoMixer)
    .function("LoudnessEBUR128", &EssentiaJS::LoudnessEBUR128)
    .function("AfterMaxToBeforeMaxEnergyRatio", &EssentiaJS::AfterMaxToBeforeMaxEnergyRatio)
    .function("AllPass", &EssentiaJS::AllPass)
    .function("AudioOnsetsMarker", &EssentiaJS::AudioOnsetsMarker)
    .function("AutoCorrelation", &EssentiaJS::AutoCorrelation)
    .function("BFCC", &EssentiaJS::BFCC)
    .function("BPF", &EssentiaJS::BPF)
    .function("BandPass", &EssentiaJS::BandPass)
    .function("BandReject", &EssentiaJS::BandReject)
    .function("BarkBands", &EssentiaJS::BarkBands)
    .function("BeatTrackerDegara", &EssentiaJS::BeatTrackerDegara)
    .function("BeatTrackerMultiFeature", &EssentiaJS::BeatTrackerMultiFeature)
    .function("Beatogram", &EssentiaJS::Beatogram)
    .function("BeatsLoudness", &EssentiaJS::BeatsLoudness)
    .function("BinaryOperator", &EssentiaJS::BinaryOperator)
    .function("BinaryOperatorStream", &EssentiaJS::BinaryOperatorStream)
    .function("BpmHistogramDescriptors", &EssentiaJS::BpmHistogramDescriptors)
    .function("BpmRubato", &EssentiaJS::BpmRubato)
    .function("CentralMoments", &EssentiaJS::CentralMoments)
    .function("Centroid", &EssentiaJS::Centroid)
    .function("ChordsDescriptors", &EssentiaJS::ChordsDescriptors)
    .function("ChordsDetection", &EssentiaJS::ChordsDetection)
    .function("ChordsDetectionBeats", &EssentiaJS::ChordsDetectionBeats)
    .function("ChromaCrossSimilarity", &EssentiaJS::ChromaCrossSimilarity)
    .function("Chromagram", &EssentiaJS::Chromagram)
    .function("ClickDetector", &EssentiaJS::ClickDetector)
    .function("Clipper", &EssentiaJS::Clipper)
    .function("CoverSongSimilarity", &EssentiaJS::CoverSongSimilarity)
    .function("Crest", &EssentiaJS::Crest)
    .function("CrossCorrelation", &EssentiaJS::CrossCorrelation)
    .function("CrossSimilarityMatrix", &EssentiaJS::CrossSimilarityMatrix)
    .function("CubicSpline", &EssentiaJS::CubicSpline)
    .function("DCRemoval", &EssentiaJS::DCRemoval)
    .function("DCT", &EssentiaJS::DCT)
    .function("Danceability", &EssentiaJS::Danceability)
    .function("Decrease", &EssentiaJS::Decrease)
    .function("Derivative", &EssentiaJS::Derivative)
    .function("DerivativeSFX", &EssentiaJS::DerivativeSFX)
    .function("DiscontinuityDetector", &EssentiaJS::DiscontinuityDetector)
    .function("Dissonance", &EssentiaJS::Dissonance)
    .function("DistributionShape", &EssentiaJS::DistributionShape)
    .function("Duration", &EssentiaJS::Duration)
    .function("DynamicComplexity", &EssentiaJS::DynamicComplexity)
    .function("ERBBands", &EssentiaJS::ERBBands)
    .function("EffectiveDuration", &EssentiaJS::EffectiveDuration)
    .function("Energy", &EssentiaJS::Energy)
    .function("EnergyBand", &EssentiaJS::EnergyBand)
    .function("EnergyBandRatio", &EssentiaJS::EnergyBandRatio)
    .function("Entropy", &EssentiaJS::Entropy)
    .function("Envelope", &EssentiaJS::Envelope)
    .function("EqualLoudness", &EssentiaJS::EqualLoudness)
    .function("Flatness", &EssentiaJS::Flatness)
    .function("FlatnessDB", &EssentiaJS::FlatnessDB)
    .function("FlatnessSFX", &EssentiaJS::FlatnessSFX)
    .function("Flux", &EssentiaJS::Flux)
    .function("FrameCutter", &EssentiaJS::FrameCutter)
    .function("FrameToReal", &EssentiaJS::FrameToReal)
    .function("FrequencyBands", &EssentiaJS::FrequencyBands)
    .function("GFCC", &EssentiaJS::GFCC)
    .function("GapsDetector", &EssentiaJS::GapsDetector)
    .function("GeometricMean", &EssentiaJS::GeometricMean)
    .function("HFC", &EssentiaJS::HFC)
    .function("HPCP", &EssentiaJS::HPCP)
    .function("HarmonicBpm", &EssentiaJS::HarmonicBpm)
    .function("HarmonicPeaks", &EssentiaJS::HarmonicPeaks)
    .function("HighPass", &EssentiaJS::HighPass)
    .function("HighResolutionFeatures", &EssentiaJS::HighResolutionFeatures)
    .function("Histogram", &EssentiaJS::Histogram)
    .function("HprModelAnal", &EssentiaJS::HprModelAnal)
    .function("HpsModelAnal", &EssentiaJS::HpsModelAnal)
    .function("IDCT", &EssentiaJS::IDCT)
    .function("IIR", &EssentiaJS::IIR)
    .function("Inharmonicity", &EssentiaJS::Inharmonicity)
    .function("InstantPower", &EssentiaJS::InstantPower)
    .function("Intensity", &EssentiaJS::Intensity)
    .function("Key", &EssentiaJS::Key)
    .function("KeyExtractor", &EssentiaJS::KeyExtractor)
    .function("LPC", &EssentiaJS::LPC)
    .function("Larm", &EssentiaJS::Larm)
    .function("Leq", &EssentiaJS::Leq)
    .function("LevelExtractor", &EssentiaJS::LevelExtractor)
    .function("LogAttackTime", &EssentiaJS::LogAttackTime)
    .function("LogSpectrum", &EssentiaJS::LogSpectrum)
    .function("LoopBpmConfidence", &EssentiaJS::LoopBpmConfidence)
    .function("LoopBpmEstimator", &EssentiaJS::LoopBpmEstimator)
    .function("Loudness", &EssentiaJS::Loudness)
    .function("LoudnessVickers", &EssentiaJS::LoudnessVickers)
    .function("LowLevelSpectralEqloudExtractor", &EssentiaJS::LowLevelSpectralEqloudExtractor)
    .function("LowLevelSpectralExtractor", &EssentiaJS::LowLevelSpectralExtractor)
    .function("LowPass", &EssentiaJS::LowPass)
    .function("MFCC", &EssentiaJS::MFCC)
    .function("MaxFilter", &EssentiaJS::MaxFilter)
    .function("MaxMagFreq", &EssentiaJS::MaxMagFreq)
    .function("MaxToTotal", &EssentiaJS::MaxToTotal)
    .function("Mean", &EssentiaJS::Mean)
    .function("Median", &EssentiaJS::Median)
    .function("MedianFilter", &EssentiaJS::MedianFilter)
    .function("MelBands", &EssentiaJS::MelBands)
    .function("Meter", &EssentiaJS::Meter)
    .function("MinMax", &EssentiaJS::MinMax)
    .function("MinToTotal", &EssentiaJS::MinToTotal)
    .function("MovingAverage", &EssentiaJS::MovingAverage)
    .function("MultiPitchKlapuri", &EssentiaJS::MultiPitchKlapuri)
    .function("MultiPitchMelodia", &EssentiaJS::MultiPitchMelodia)
    .function("Multiplexer", &EssentiaJS::Multiplexer)
    .function("NNLSChroma", &EssentiaJS::NNLSChroma)
    .function("NoiseAdder", &EssentiaJS::NoiseAdder)
    .function("NoiseBurstDetector", &EssentiaJS::NoiseBurstDetector)
    .function("NoveltyCurve", &EssentiaJS::NoveltyCurve)
    .function("NoveltyCurveFixedBpmEstimator", &EssentiaJS::NoveltyCurveFixedBpmEstimator)
    .function("OddToEvenHarmonicEnergyRatio", &EssentiaJS::OddToEvenHarmonicEnergyRatio)
    .function("OnsetDetection", &EssentiaJS::OnsetDetection)
    .function("OnsetDetectionGlobal", &EssentiaJS::OnsetDetectionGlobal)
    .function("OnsetRate", &EssentiaJS::OnsetRate)
    .function("OverlapAdd", &EssentiaJS::OverlapAdd)
    .function("PeakDetection", &EssentiaJS::PeakDetection)
    .function("PercivalBpmEstimator", &EssentiaJS::PercivalBpmEstimator)
    .function("PercivalEnhanceHarmonics", &EssentiaJS::PercivalEnhanceHarmonics)
    .function("PercivalEvaluatePulseTrains", &EssentiaJS::PercivalEvaluatePulseTrains)
    .function("PitchContourSegmentation", &EssentiaJS::PitchContourSegmentation)
    .function("PitchContours", &EssentiaJS::PitchContours)
    .function("PitchContoursMelody", &EssentiaJS::PitchContoursMelody)
    .function("PitchContoursMonoMelody", &EssentiaJS::PitchContoursMonoMelody)
    .function("PitchContoursMultiMelody", &EssentiaJS::PitchContoursMultiMelody)
    .function("PitchFilter", &EssentiaJS::PitchFilter)
    .function("PitchMelodia", &EssentiaJS::PitchMelodia)
    .function("PitchSalience", &EssentiaJS::PitchSalience)
    .function("PitchSalienceFunction", &EssentiaJS::PitchSalienceFunction)
    .function("PitchSalienceFunctionPeaks", &EssentiaJS::PitchSalienceFunctionPeaks)
    .function("PitchYin", &EssentiaJS::PitchYin)
    .function("PitchYinFFT", &EssentiaJS::PitchYinFFT)
    .function("PitchYinProbabilistic", &EssentiaJS::PitchYinProbabilistic)
    .function("PitchYinProbabilities", &EssentiaJS::PitchYinProbabilities)
    .function("PitchYinProbabilitiesHMM", &EssentiaJS::PitchYinProbabilitiesHMM)
    .function("PowerMean", &EssentiaJS::PowerMean)
    .function("PowerSpectrum", &EssentiaJS::PowerSpectrum)
    .function("PredominantPitchMelodia", &EssentiaJS::PredominantPitchMelodia)
    .function("RMS", &EssentiaJS::RMS)
    .function("RawMoments", &EssentiaJS::RawMoments)
    .function("ReplayGain", &EssentiaJS::ReplayGain)
    .function("Resample", &EssentiaJS::Resample)
    .function("ResampleFFT", &EssentiaJS::ResampleFFT)
    .function("RhythmDescriptors", &EssentiaJS::RhythmDescriptors)
    .function("RhythmExtractor", &EssentiaJS::RhythmExtractor)
    .function("RhythmExtractor2013", &EssentiaJS::RhythmExtractor2013)
    .function("RhythmTransform", &EssentiaJS::RhythmTransform)
    .function("RollOff", &EssentiaJS::RollOff)
    .function("SNR", &EssentiaJS::SNR)
    .function("SaturationDetector", &EssentiaJS::SaturationDetector)
    .function("Scale", &EssentiaJS::Scale)
    .function("SineSubtraction", &EssentiaJS::SineSubtraction)
    .function("SingleBeatLoudness", &EssentiaJS::SingleBeatLoudness)
    .function("Slicer", &EssentiaJS::Slicer)
    .function("SpectralCentroidTime", &EssentiaJS::SpectralCentroidTime)
    .function("SpectralComplexity", &EssentiaJS::SpectralComplexity)
    .function("SpectralContrast", &EssentiaJS::SpectralContrast)
    .function("SpectralPeaks", &EssentiaJS::SpectralPeaks)
    .function("SpectralWhitening", &EssentiaJS::SpectralWhitening)
    .function("Spectrum", &EssentiaJS::Spectrum)
    .function("SpectrumCQ", &EssentiaJS::SpectrumCQ)
    .function("SpectrumToCent", &EssentiaJS::SpectrumToCent)
    .function("Spline", &EssentiaJS::Spline)
    .function("SprModelAnal", &EssentiaJS::SprModelAnal)
    .function("SprModelSynth", &EssentiaJS::SprModelSynth)
    .function("SpsModelAnal", &EssentiaJS::SpsModelAnal)
    .function("SpsModelSynth", &EssentiaJS::SpsModelSynth)
    .function("StartStopCut", &EssentiaJS::StartStopCut)
    .function("StartStopSilence", &EssentiaJS::StartStopSilence)
    .function("StochasticModelAnal", &EssentiaJS::StochasticModelAnal)
    .function("StochasticModelSynth", &EssentiaJS::StochasticModelSynth)
    .function("StrongDecay", &EssentiaJS::StrongDecay)
    .function("StrongPeak", &EssentiaJS::StrongPeak)
    .function("SuperFluxExtractor", &EssentiaJS::SuperFluxExtractor)
    .function("SuperFluxNovelty", &EssentiaJS::SuperFluxNovelty)
    .function("SuperFluxPeaks", &EssentiaJS::SuperFluxPeaks)
    .function("TCToTotal", &EssentiaJS::TCToTotal)
    .function("TempoScaleBands", &EssentiaJS::TempoScaleBands)
    .function("TempoTap", &EssentiaJS::TempoTap)
    .function("TempoTapDegara", &EssentiaJS::TempoTapDegara)
    .function("TempoTapMaxAgreement", &EssentiaJS::TempoTapMaxAgreement)
    .function("TempoTapTicks", &EssentiaJS::TempoTapTicks)
    .function("TensorflowInputMusiCNN", &EssentiaJS::TensorflowInputMusiCNN)
    .function("TensorflowInputVGGish", &EssentiaJS::TensorflowInputVGGish)
    .function("TonalExtractor", &EssentiaJS::TonalExtractor)
    .function("TonicIndianArtMusic", &EssentiaJS::TonicIndianArtMusic)
    .function("TriangularBands", &EssentiaJS::TriangularBands)
    .function("TriangularBarkBands", &EssentiaJS::TriangularBarkBands)
    .function("Trimmer", &EssentiaJS::Trimmer)
    .function("Tristimulus", &EssentiaJS::Tristimulus)
    .function("TruePeakDetector", &EssentiaJS::TruePeakDetector)
    .function("TuningFrequency", &EssentiaJS::TuningFrequency)
    .function("TuningFrequencyExtractor", &EssentiaJS::TuningFrequencyExtractor)
    .function("UnaryOperator", &EssentiaJS::UnaryOperator)
    .function("UnaryOperatorStream", &EssentiaJS::UnaryOperatorStream)
    .function("Variance", &EssentiaJS::Variance)
    .function("Vibrato", &EssentiaJS::Vibrato)
    .function("WarpedAutoCorrelation", &EssentiaJS::WarpedAutoCorrelation)
    .function("Welch", &EssentiaJS::Welch)
    .function("Windowing", &EssentiaJS::Windowing)
    .function("ZeroCrossingRate", &EssentiaJS::ZeroCrossingRate)
    ;
  // utility function to convert a Float32 JS typed array into std::vector<float>
  function("arrayToVector", &float32ArrayToVector);
  // expose stl datatypes to js
  register_vector<int>("VectorInt");
  register_vector<float>("VectorFloat");
  register_vector<double>("VectorDouble");
  register_vector<std::string>("VectorString");
  register_vector<std::vector<float>>("VectorVectorFloat");
  register_vector<std::vector<double>>("VectorVectorDouble");
}
