import typescript from 'rollup-plugin-typescript2';
import {terser} from "rollup-plugin-terser";

// global var to assign build settings object
let EXPORT_BUILD_OPTS;

// code snippet to accept custom target build paths if specified in cmd-line.
let DIST_DIR;
if (!("DIST_DIR" in process.env)) {
  DIST_DIR = "dist";
} else {
  DIST_DIR = process.env.DIST_DIR;
};

// default configuration options for building Essentia.js core JS API and add-on modules
let defaultBuildOpts = [{
  input: 'src/typescript/core_api.ts', // our source file
  output: [
    {
    file: DIST_DIR + '/essentia.js-core.es.min.js',
    format: 'es' // the preferred format
    },
    {
      file: DIST_DIR + '/essentia.js-core.umd.min.js',
      format: 'umd',
      name: 'Essentia' // the global which can be used during imports
    },
    {
    file: DIST_DIR + '/essentia.js-core.min.js',
    format: 'iife',
    name: 'Essentia' // the global which can be used in a browser
    }
  ],
  plugins: [
    typescript({
    typescript: require('typescript'),
    }),
  ]
}, {
  input: 'src/typescript/machinelearning/index.ts', // our source file
  output: [
   {
    file: DIST_DIR + '/essentia.js-model.es.min.js',
    format: 'es' // the preferred format
   },
   {
    file: DIST_DIR + '/essentia.js-model.umd.min.js',
    format: 'umd',
    name: 'EssentiaModel' // the global which can be used during imports
   },
   {
    file: DIST_DIR + '/essentia.js-model.min.js',
    format: 'iife',
    name: 'EssentiaModel' // the global which can be used in a browser
   }
  ],
  plugins: [
   typescript({
    typescript: require('typescript'),
   }),
  ]
 }, {
 input: 'src/typescript/display/plot.ts', // our source file
 output: [
  {
   file: DIST_DIR + '/essentia.js-plot.es.min.js',
   format: 'es' // the preferred format
  },
  {
    file: DIST_DIR + '/essentia.js-plot.umd.min.js',
    format: 'umd',
    name: 'EssentiaPlot' // the global which can be used during imports
   },
  {
   file: DIST_DIR + '/essentia.js-plot.min.js',
   format: 'iife',
   name: 'EssentiaPlot' // the global which can be used in a browser
  }
 ],
 plugins: [
  typescript({
   typescript: require('typescript'),
  }),
 ]
}, {
  input: 'src/typescript/extractor/extractor.ts', // our source file
  output: [
   {
    file: DIST_DIR + '/essentia.js-extractor.es.min.js',
    format: 'es' // the preferred format
   },
   {
    file: DIST_DIR + '/essentia.js-extractor.umd.min.js',
    format: 'umd',
    name: 'EssentiaExtractor' // the global which can be used during imports
   },
   {
    file: DIST_DIR + '/essentia.js-extractor.min.js',
    format: 'iife',
    name: 'EssentiaExtractor' // the global which can be used in a browser
   }
  ],
  plugins: [
   typescript({
    typescript: require('typescript'),
   }),
  ]
 }
]

// code snippet to adapt cmd-line options for building builds with/without add-on modules.
let IS_ADDON;
if (!("ESSENTIAJS_ADDON" in process.env)) {
  EXPORT_BUILD_OPTS = defaultBuildOpts;
} else {
  IS_ADDON = Boolean(Number(process.env.ESSENTIAJS_ADDON));
  if (IS_ADDON) {
    EXPORT_BUILD_OPTS = defaultBuildOpts;
  } else {
    defaultBuildOpts.forEach(function (item, index) {
      // remove all the add-on modules from build settings
      if (index >= 0) defaultBuildOpts.pop();
    });
    EXPORT_BUILD_OPTS = defaultBuildOpts;
  }
};

// add code compression to the build settings using rollup-terser plugin
EXPORT_BUILD_OPTS.forEach(function(item) {
  item.plugins.push(terser());
});

export default EXPORT_BUILD_OPTS;