#!/bin/bash
set -ae
prefix="$(realpath "$(dirname "$0")")/essentia-prefix"

if [ "$1" = init ]; then
	mkdir -p "$prefix/essentia" "$prefix/essentia.js"

	pushd "$prefix/essentia"
	git init
	git remote add origin https://github.com/MTG/essentia
	git fetch --depth 1 origin 46f8bd9f5a3029ede18dfa251ccc30a9c682cf88
	git checkout FETCH_HEAD
	# Use libeigen3-dev from Debian repositories.
	sed -i.bak s,packaging/debian_3rdparty/lib/pkgconfig,/usr/share/pkgconfig, wscript
	# Delete prebuilt FFTW, libav, libsamplerate, taglib and yaml.
	rm -r packaging/win32_3rdparty
	popd

	pushd "$prefix/essentia.js"
	git init
	git remote add origin https://github.com/MTG/essentia.js
	git fetch --depth 1 origin 819c00e8f034dc709e3d330ed8ac9ed37dfdb767
	git checkout FETCH_HEAD
	# Delete prebuilt WASM.
	rm -r examples
	popd
fi

if [ "$1" = build ]; then
	pushd "$prefix/essentia"
	emconfigure python3 waf configure --prefix="$prefix" --build-static --fft=KISS --emscripten --static-dependencies
	emmake python3 waf
	emmake python3 waf install
	popd

	pushd "$prefix/essentia.js"
	emcc -lembind -Oz src/cpp/bindings_essentiajs.cpp src/cpp/includes/essentiajs.cpp -lembind -lessentia -L "$prefix/lib" -I /usr/include/eigen3 -I "$prefix/include" -s WASM=1 -o "$prefix/../../../node_modules/essentia.js/dist/essentia-wasm.web.js" -s EXCEPTION_DEBUG -s ASSERTIONS=2 -s ENVIRONMENT=web -s MODULARIZE=1 -s EXPORT_NAME="EssentiaWASM" --post-js src/js/wasm.webmodule.post.js -s ALLOW_MEMORY_GROWTH=1
	popd
fi
