package org.codeberg.genericpers0n.soundrecorderplus.fragments;

import android.os.Bundle;

import androidx.annotation.Nullable;
import androidx.preference.CheckBoxPreference;
import androidx.preference.Preference;
import androidx.preference.PreferenceFragmentCompat;

import org.codeberg.genericpers0n.soundrecorderplus.BuildConfig;
import org.codeberg.genericpers0n.soundrecorderplus.MySharedPreferences;
import org.codeberg.genericpers0n.soundrecorderplus.R;

/**
 * Created by Daniel on 5/22/2017.
 */

public class SettingsFragment extends PreferenceFragmentCompat {
    @Override
    public void onCreatePreferences(@Nullable Bundle savedInstanceState, @Nullable String rootKey) {
        // TODO
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        addPreferencesFromResource(R.xml.preferences);

        CheckBoxPreference highQualityPref = findPreference(getResources().getString(R.string.pref_high_quality_key));
        highQualityPref.setChecked(MySharedPreferences.getPrefHighQuality(getActivity()));
        highQualityPref.setOnPreferenceChangeListener((preference, newValue) -> {
            MySharedPreferences.setPrefHighQuality(getActivity(), (boolean) newValue);
            return true;
        });

        Preference aboutPref = findPreference(getString(R.string.pref_about_key));
        aboutPref.setSummary(getString(R.string.pref_about_desc, BuildConfig.VERSION_NAME));
        aboutPref.setOnPreferenceClickListener(preference -> {
            LicensesFragment licensesFragment = new LicensesFragment();
            licensesFragment.show(getActivity().getSupportFragmentManager().beginTransaction(), "dialog_licenses");
            return true;
        });
    }
}
