package org.codeberg.genericpers0n.soundrecorderplus.activities;

import android.Manifest;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.viewpager2.adapter.FragmentStateAdapter;
import androidx.viewpager2.widget.ViewPager2;

import com.google.android.material.tabs.TabLayout;
import com.google.android.material.tabs.TabLayoutMediator;
import org.codeberg.genericpers0n.soundrecorderplus.R;
import org.codeberg.genericpers0n.soundrecorderplus.fragments.FileViewerFragment;
import org.codeberg.genericpers0n.soundrecorderplus.fragments.RecordFragment;


public class MainActivity extends AppCompatActivity {

    public static String[] tabTitles;

    private final int PERMISSIONS_REQUEST = 0;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        // Setup tab titles
        tabTitles = new String[] {
                getString(R.string.tab_title_record),
                getString(R.string.tab_title_saved_recordings)
        };

        ViewPager2 pager = findViewById(R.id.pager);
        pager.setAdapter(new MyAdapter(this));
        TabLayout tabs = findViewById(R.id.tabs);
        TabLayoutMediator tabLayoutMediator = new TabLayoutMediator(
                tabs,
                pager,
                (tab, position) -> tab.setText(tabTitles[position])
        );
        tabLayoutMediator.attach();

        setSupportActionBar(findViewById(R.id.toolbar));

        if (checkSelfPermission(Manifest.permission.RECORD_AUDIO) == PackageManager.PERMISSION_DENIED)
        {
            ActivityCompat.requestPermissions(
                    this,
                    new String[] {Manifest.permission.RECORD_AUDIO},
                    PERMISSIONS_REQUEST
            );
        } else {
            Log.i("SoundRecorderPlus", "Audio permission already granted");
        }
    }

    @Override
    public void onRequestPermissionsResult(
            int requestCode,
            @NonNull String[] permissions,
            @NonNull int[] grantResults
    ) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == PERMISSIONS_REQUEST) {
            if (grantResults.length > 0 &&
                    grantResults[0] != PackageManager.PERMISSION_GRANTED) {
                Log.e("SoundRecorderPlus", "REQUEST_MEDIA denied" + permissions.length);
            }
        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.menu_main, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        // Handle presses on the action bar items
        if (item.getItemId() == R.id.action_settings) {
            Intent i = new Intent(this, SettingsActivity.class);
            startActivity(i);
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public static class MyAdapter extends FragmentStateAdapter {
public MyAdapter(@NonNull FragmentActivity fragmentActivity)
        {
            super(fragmentActivity);
        }

        @Override
        @NonNull
        public Fragment createFragment(int position) {
            if (position == 1) {
                return FileViewerFragment.newInstance(position);
            } else {
                // Return a new record fragment by default.
                return RecordFragment.newInstance(position);
            }
        }

        @Override
        public int getItemCount() {
            return tabTitles.length;
        }
    }

    public MainActivity() {
    }
}
