# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.1.0/).

## [0.9.2] - 2025-01-25

- Add merchant boosts
- Add comments screen
- Speed up element search within an area
- Show user location marker
- Improve Material theme support
- Remove Google blob from APK
- Show more info on deleted elements
- Add Polish translation
- Add Brazilian translation
- Fix issue with reports
- Fix issue with distance units
- Fix crashes under certain conditions

- Allow users to post merchant comments
- Fix issue with cold sync
- Add special icon for debug builds
- Improve error handling

## [0.9.1] - 2025-01-18

- Allow users to post merchant comments
- Fix issue with cold sync
- Add special icon for debug builds
- Improve error handling

## [0.9.0] - 2025-01-13

- Switch to vector maps
- Change marker colors in light mode
- Fix verification reports

## [0.8.0] - 2024-10-24

- Show place comments
- Hide ATMs by default
- Show places offering delivery
- Migrate to faster and more efficient v3 API

## [0.7.3] - 2024-05-03

- Bundle the latest data snapshots
- Remove sync progress indicator from the map screen
- Add place directions
- Add share location button
- Add companion app warnings for the minority of places which require it
- Fix crashes during sync

## [0.7.2] - 2024-04-26

- Notify user of new places nearby
- Perform daily sync in background
- Handle API rate limiting

## [0.7.1] - 2024-03-17

- Fix issue with deleted places not being shown in a change log
- Fix issue with date format
- Warn the users about outdated places

## [0.7.0] - 2024-02-18

- Show community meetup locations
- Show community description, if available
- Add area issues screen
- Change default location to Curacao
- Zoom to current location
- Enable search by localized place categories
- Show percentage of verified places
- Show days since verified
- Add Portuguese translation
- Show place images, when available
- Hide deleted reports
- Show issues count on area screen
- Let debug builds coexist with the release builds

## [0.6.6] - 2023-06-06

- Allow users to hide ATMs permanently in settings
- Update verify link to single id param
- Change status bar color when place view is expanded
- Add more validations
- Improve Greek translation
- Improve German translation

## [0.6.5] - 2023-04-24

- Fix issue with sync status reporting
- Improve search
- Improve dark mode support
- Show translated place names, when available
- Improve French translation
- Improve Russian translation
- Improve Spanish translation
- Improve Thai translation

## [0.6.4] - 2023-04-09

- Add dark tiles
- Speed up initial sync
- Show last sync date in settings
- Improve Turkish translation

## [0.6.2] - 2023-03-04

- Add incremental sync
- Show sync indicator
- Update donation info

## [0.6.1] - 2023-02-05

- Fix issue with out of sync cache
- Improve place picker animation
- Cache downloaded images
- Speed up communities screen
- Speed up community screen
- Order places by verification date
- Use polygon bounding box when selecting communities

## [0.6.0] - 2023-01-20

- Show community reports
- Show more precise community bounds, when available
- Show boosted places
- Update search bar

## [0.5.10] - 2022-11-22

- Show more verification tags
- Prettify charts

## [0.5.9] - 2022-11-10

- Improve payment flow
- Fix issue with event parsing

## [0.5.7] - 2022-11-09

- Bring back 32-bit ARM support
- Add pay with Pouch button
- Exclude certain users and bots from the leaderboard

## [0.5.6] - 2022-11-05

- Speed-up sync
- Enable Brotli compression
- Upgrade Material components

## [0.5.5] - 2022-11-03

- Fix cluster placement
- Fix app freezes
- Reduce APK size

## [0.5.4] - 2022-11-01

- Change place icon style
- Show more icons

## [0.5.3] - 2022-10-30

- Fix issue with clustering
- Add verify place button
- Prettify social links

## [0.5.2] - 2022-10-29

- Improve clustering

## [0.5.1] - 2022-10-26

- Show more contact details
- Improve dynamic theme switching

## [0.5.0] - 2022-10-25

- Connect OpenStreetMap account (optional)
- Add built-in tag editor

## [0.4.13] - 2022-10-23

- Show more contact methods
- Prettify links
- Allow users to go back to search results
- Save scroll position on taggers screen
- Fix issue with Australia

## [0.4.12] - 2022-10-22

- Show community contact details
- Speed up community screen
- Show last verification date for every place

## [0.4.11] - 2022-10-19

- Speed up map
- Allow users to report outdated places
- Switch to new areas API
- Fix a few bugs

## [0.4.10] - 2022-10-17

- Speed up events loading
- Show Facebook links
- Don't count deleted events
- Speed up area screen
- Show area icons
- Make user edits clickable

## [0.4.9] - 2022-10-15

- Speed up sync
- Re-design pin clusters
- Save scroll position on recent changes screen
- Speed up recent changes loading
- Show pins on place screen
- Sort communities by distance
- Add more place actions

## [0.4.8] - 2022-10-14

- Show last verification dates

## [0.4.7] - 2022-10-13

- Add element screen
- Improve screen transitions
- Re-arrange menu items
- Change event timeline icons
- Fix a few minor bugs
- Include all contributions made by Bill on Bitcoin Island

## [0.4.6] - 2022-10-13

- Flush users cache

## [0.4.5] - 2022-10-12

- Add user profile screen
- Add area screen
- Remove sync indicator
- Improve location permissions handling
- Speed up sync

## [0.4.4] - 2022-10-11

- Fix signature

## [0.4.3] - 2022-10-11

- Prettify charts
- Speed up DB queries to make all screens instantly loadable

## [0.4.2] - 2022-10-10

- Prettify charts
- Add top mappers screen
- Make areas selectable
- Cache areas
- Cache users
- Cache events

## [0.4.1] - 2022-10-08

- Add OSM link on element screen
- Hide deleted places
- Add more icons
- Don't show countries on communities screen

## [0.4.0] - 2022-10-07

- Show daily reports in offline mode
- Add OSM attribution
- Make element events clickable
- Bug fixes and performance improvements

## [0.3.11] - 2022-10-06

- Improve LNURL parsing

## [0.3.10] - 2022-10-06

- Add Lightning tips
- Re-design latest changes screen

## [0.3.9] - 2022-10-05

- Save last location
- Make icons easier to click

## [0.3.8] - 2022-10-05

- Add communities screen
- Change default location

## [0.3.7] - 2022-10-04

- Add trends screen
- Simplify donation flow
- Fix minor issue with navigation

## [0.3.6] - 2022-10-04

- Add themed pins
- Add dark map
- Add settings screen
- Speed up search
- Speed up sync

## [0.3.5] - 2022-09-16

- Change launcher icon
- Provide monochrome icon
- Introduce minimal sync interval
- Change pin appearance

## [0.3.4] - 2022-09-04

- Highlight LN-enabled places
- Sync elements every time the map is shown

## [0.3.3] - 2022-07-11

- Add more place icons
- Show Lightning-enabled places
- Fix issue with pin size

## [0.3.2] - 2022-06-09

- Provide self-signed APK for each release
- Provide self-signed APKs for latest commits
- Add more icons
- Minor bugfixes

## [0.2.0] - 2022-05-27

- Add dark mode support for map pins
- Shrink APK size
- Cluster pins in dense areas
- Support bundled data (optional)
- Add more place icons
- Improve sync

## [0.1.0] - 2022-05-14
