/*
 * Decompiled with CFR 0.152.
 */
package org.androidsoft.utils.ui;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import org.androidsoft.utils.ui.NoTitleActivity;

public abstract class WhatsNewActivity
extends NoTitleActivity {
    private static final String KEY_VERSION = "version";
    private static final int DEFAULT_VERSION = -1;

    public abstract int getFirstRunDialogTitleRes();

    public abstract int getFirstRunDialogMsgRes();

    public abstract int getWhatsNewDialogTitleRes();

    public abstract int getWhatsNewDialogMsgRes();

    @Override
    public void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.checkLastVersion();
    }

    private void checkLastVersion() {
        int currentVersion;
        int lastVersion = this.getSavedVersion();
        if (lastVersion < (currentVersion = this.getVersionNumber())) {
            int resMessage;
            int resTitle;
            if (lastVersion == -1) {
                resTitle = this.getFirstRunDialogTitleRes();
                resMessage = this.getFirstRunDialogMsgRes();
            } else {
                resTitle = this.getWhatsNewDialogTitleRes();
                resMessage = this.getWhatsNewDialogMsgRes();
            }
            this.saveVersion(currentVersion);
            this.showWhatsNewDialog(resTitle, resMessage);
        }
    }

    private int getSavedVersion() {
        SharedPreferences prefs = this.getPreferences(0);
        return prefs.getInt(KEY_VERSION, -1);
    }

    private void saveVersion(int version) {
        SharedPreferences prefs = this.getPreferences(0);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putInt(KEY_VERSION, version);
        editor.commit();
    }

    private void showWhatsNewDialog(int title, int message) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setTitle(title);
        builder.setIcon(17301569);
        builder.setMessage(message);
        builder.setPositiveButton((CharSequence)this.getString(17039370), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id) {
                dialog.cancel();
            }
        });
        AlertDialog alert = builder.create();
        alert.show();
    }

    public int getVersionNumber() {
        int versionNo = 0;
        PackageInfo pInfo = null;
        try {
            pInfo = this.getPackageManager().getPackageInfo(this.getPackageName(), 128);
        }
        catch (PackageManager.NameNotFoundException e) {
            pInfo = null;
        }
        if (pInfo != null) {
            versionNo = pInfo.versionCode;
        }
        return versionNo;
    }
}

