package net.xisberto.timerpx.database

class WidgetRepository(private val database: Database) {

    fun get(appWidgetId: Int) = database.widtetDao().get(appWidgetId)

    fun insert(timerWidget: TimerWidget): Long = database.widtetDao().insert(timerWidget)

    fun delete(timerWidget: TimerWidget) = database.widtetDao().delete(timerWidget)

    fun delete(appWidgetId: Int) {
        val widgetAndDef = get(appWidgetId) ?: return
        database.widtetDao().delete(checkNotNull(widgetAndDef.widget))
    }
}