package net.xisberto.timerpx.database

import android.app.Application
import androidx.lifecycle.AndroidViewModel
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.viewModelScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch

class TimerViewModel(application: Application) : AndroidViewModel(application) {
    private val repository: TimerRepository
    val allTimers: LiveData<List<TimerDef>>
    val action = MutableLiveData<Int>()
    val selection = MutableLiveData<TimerDef>()

    init {
        val database = Database.getDatabase(application.applicationContext)
        repository = TimerRepository(database)
        allTimers = repository.allTimers
    }

    fun insert(timerDef: TimerDef) = viewModelScope.launch(Dispatchers.IO) {
        repository.insert(timerDef)
    }

    fun delete(timerDef: TimerDef) = viewModelScope.launch(Dispatchers.IO) {
        repository.delete(timerDef)
    }

}